/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.swt;

import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.core.style.HorizontalAlignment;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

@NonNullByDefault
public class SwtUtils {
    public static final @Nullable ScrollBar getScrollBar(Scrollable control, Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return control.getHorizontalBar();
            }
            case VERTICAL: {
                return control.getVerticalBar();
            }
        }
        throw new IllegalStateException();
    }

    public static final int get(Point point, Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return point.x;
            }
            case VERTICAL: {
                return point.y;
            }
        }
        throw new IllegalStateException();
    }

    public static final int getStart(Rectangle rect, Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return rect.x;
            }
            case VERTICAL: {
                return rect.y;
            }
        }
        throw new IllegalStateException();
    }

    public static final int getEnd(Rectangle rect, Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return rect.x + rect.width;
            }
            case VERTICAL: {
                return rect.y + rect.height;
            }
        }
        throw new IllegalStateException();
    }

    public static final int getSize(Rectangle rect, Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return rect.width;
            }
            case VERTICAL: {
                return rect.height;
            }
        }
        throw new IllegalStateException();
    }

    public static final int toSWT(long pixel) {
        if (pixel < Integer.MIN_VALUE || pixel > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return (int)pixel;
    }

    public static final Rectangle toSWT(LRectangle rect) {
        return new Rectangle(SwtUtils.toSWT(rect.x), SwtUtils.toSWT(rect.y), SwtUtils.toSWT(rect.width), SwtUtils.toSWT(rect.height));
    }

    public static final LRectangle toNatTable(Rectangle rect) {
        return new LRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public static final Point toSWT(LPoint lPoint) {
        return new Point(SwtUtils.toSWT(lPoint.x), SwtUtils.toSWT(lPoint.y));
    }

    public static final int toSWT(HorizontalAlignment alignment) {
        switch (alignment) {
            case LEFT: {
                return 16384;
            }
            case CENTER: {
                return 0x1000000;
            }
            case RIGHT: {
                return 131072;
            }
        }
        throw new IllegalStateException();
    }

    public static final int toSWT(BorderStyle.LineStyle lineStyle) {
        switch (lineStyle) {
            case SOLID: {
                return 1;
            }
            case DASHED: {
                return 2;
            }
            case DOTTED: {
                return 3;
            }
            case DASHDOT: {
                return 4;
            }
            case DASHDOTDOT: {
                return 5;
            }
        }
        throw new IllegalStateException();
    }

    public static final int getMouseWheelEventType(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return 38;
            }
            case VERTICAL: {
                return 37;
            }
        }
        throw new IllegalStateException();
    }

    public static final int getPixel(MouseEvent event, Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return event.x;
            }
            case VERTICAL: {
                return event.y;
            }
        }
        throw new IllegalStateException();
    }
}

