/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.core;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerListener;
import org.eclipse.statet.ecommons.waltable.core.layer.events.StructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.events.StructuralDiff;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SelectionLayerStructuralChangeEventHandler
implements LayerListener {
    private final SelectionModel selectionModel;
    private final SelectionLayer selectionLayer;

    public SelectionLayerStructuralChangeEventHandler(SelectionLayer selectionLayer, SelectionModel selectionModel) {
        this.selectionLayer = selectionLayer;
        this.selectionModel = selectionModel;
    }

    @Override
    public void handleLayerEvent(LayerEvent event) {
        block9: {
            if (!(event instanceof StructuralChangeEvent)) break block9;
            StructuralChangeEvent changeEvent = (StructuralChangeEvent)event;
            if (changeEvent.isStructureChanged(Orientation.HORIZONTAL)) {
                this.selectionLayer.clear();
                return;
            }
            if (changeEvent.isStructureChanged(Orientation.VERTICAL)) {
                List<StructuralDiff> rowDiffs = changeEvent.getDiffs(Orientation.VERTICAL);
                if (rowDiffs == null) {
                    List<LRectangle> lRectangles = changeEvent.getChangedPositionRectangles();
                    for (LRectangle lRectangle : lRectangles) {
                        LRange changedRange = new LRange(lRectangle.y, lRectangle.y + lRectangle.height);
                        if (!this.selectedRowModified(changedRange)) continue;
                        if (this.selectionLayer.getRowCount() > 0L) {
                            long columnPosition = this.selectionLayer.getSelectionAnchor().columnPosition;
                            if (columnPosition == Long.MIN_VALUE) {
                                columnPosition = 0L;
                            }
                            this.selectionLayer.setSelectionToCell(columnPosition, 0L, false);
                        } else {
                            this.selectionLayer.clear();
                        }
                        return;
                    }
                } else {
                    for (StructuralDiff diff : rowDiffs) {
                        if (diff.getDiffType() == StructuralDiff.DiffType.CHANGE || !this.selectedRowModified(diff.getBeforePositionRange())) continue;
                        this.selectionLayer.clear();
                        return;
                    }
                }
            }
        }
    }

    private boolean selectedRowModified(LRange changedRange) {
        LRangeList selectedRows = this.selectionModel.getSelectedRowPositions();
        for (LRange range : selectedRows) {
            if (!range.overlap(changedRange)) continue;
            return true;
        }
        return false;
    }
}

