/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.core.style.VerticalAlignment;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class VerticalAlignmentPicker
extends Composite {
    private final Combo combo;

    public VerticalAlignmentPicker(Composite parent, VerticalAlignment alignment) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout());
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(new String[]{Messages.getString("VerticalAlignmentPicker.top"), Messages.getString("VerticalAlignmentPicker.middle"), Messages.getString("VerticalAlignmentPicker.bottom")});
        this.update(alignment);
    }

    private void update(VerticalAlignment alignment) {
        if (alignment.equals((Object)VerticalAlignment.TOP)) {
            this.combo.select(0);
        } else if (alignment.equals((Object)VerticalAlignment.MIDDLE)) {
            this.combo.select(1);
        } else if (alignment.equals((Object)VerticalAlignment.BOTTOM)) {
            this.combo.select(2);
        } else {
            throw new IllegalArgumentException("bad alignment: " + (Object)((Object)alignment));
        }
    }

    public VerticalAlignment getSelectedAlignment() {
        long idx = this.combo.getSelectionIndex();
        if (idx == 0L) {
            return VerticalAlignment.TOP;
        }
        if (idx == 1L) {
            return VerticalAlignment.MIDDLE;
        }
        if (idx == 2L) {
            return VerticalAlignment.BOTTOM;
        }
        throw new IllegalStateException("shouldn't happen");
    }

    public void setSelectedAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(verticalAlignment);
    }
}

