/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime.bundle;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.ClassLoaderUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntryProvider;
import org.eclipse.statet.jcommons.runtime.bundle.BundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.DefaultBundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.RefClassBundleResolver;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class Bundles {
    public static final String BUNDLE_RESOLVERS_PROPERTY_KEY = "org.eclipse.statet.jcommons.runtime.bundle.BundleResolvers";
    private static final Pattern REF_CLASS_JAR_PATTERN = Pattern.compile(String.valueOf(Pattern.quote("org.eclipse.statet.jcommons.util/target/org.eclipse.statet.jcommons.util")) + "[^/!]+.jar(?:[!]|$)");
    private static final String FILE_PROTOCOL_REGEX = "\\Qfile:/\\E";
    private static final String JAR_FILE_PROTOCOL_REGEX = "\\Qjar:file:/\\E";
    private static final String BUNDLE_ID_REGEX = "[a-z]+(?:\\.?[a-z]+)*";
    private static final String VER_1_REGEX = "\\_\\d+\\.\\d+[^!/]+";
    private static final String VER_2_REGEX = "\\-\\d+\\.\\d+[^!/]+";
    private static final String JAR_REGEX = "(?<![-._]sources?)\\Q.jar\\E";
    private static final String AUTODETECT_REGEX = "(?:(\\Qfile:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*)\\Q/target/classes/\\E|(\\Qjar:file:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*(?:(\\_\\d+\\.\\d+[^!/]+)|(\\-\\d+\\.\\d+[^!/]+))?(?<![-._]sources?)\\Q.jar\\E)\\Q!/\\E)";
    private static final Pattern AUTODETECT_PATTERN = Pattern.compile("(?:(\\Qfile:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*)\\Q/target/classes/\\E|(\\Qjar:file:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*(?:(\\_\\d+\\.\\d+[^!/]+)|(\\-\\d+\\.\\d+[^!/]+))?(?<![-._]sources?)\\Q.jar\\E)\\Q!/\\E)");
    private static final int AUTODETECT_FILE_PROTOCOL_BASE_NUM = 1;
    private static final int AUTODETECT_FILE_PROTOCOL_NAME_NUM = 2;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_BASE_NUM = 3;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_NAME_NUM = 4;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_VER_1_NUM = 5;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_VER_2_NUM = 6;
    private static final Pattern JAR_VER_0_PATTERN = Pattern.compile("(.+?)(?<![-._]sources?)\\Q.jar\\E");
    private static final Pattern JAR_VER_1_PATTERN = Pattern.compile("(.+?)\\_\\d+\\.\\d+[^!/]+(?<![-._]sources?)\\Q.jar\\E");
    private static final Pattern JAR_VER_2_PATTERN = Pattern.compile("(.+?)\\-\\d+\\.\\d+[^!/]+(?<![-._]sources?)\\Q.jar\\E");

    public static BundleResolver createResolver() throws StatusException {
        String id = System.getProperty(BUNDLE_RESOLVERS_PROPERTY_KEY);
        if (id == null || id.isEmpty()) {
            BundleEntry bundleEntry = Bundles.detectEntry(Bundles.class);
            id = bundleEntry instanceof BundleEntry.Jar && !REF_CLASS_JAR_PATTERN.matcher(bundleEntry.getUrlString()).find() ? "BundleEntryProvider" : "RefClass";
        }
        return Bundles.createResolver(id);
    }

    static BundleResolver createResolver(String id) throws StatusException {
        if (id.equals("BundleEntryProvider")) {
            return new DefaultBundleResolver(Bundles.detectEntryProvider(Bundles.class));
        }
        if (id.equals("RefClass")) {
            return new RefClassBundleResolver();
        }
        if (id.indexOf(46) > 0) {
            try {
                Class<?> resolverClass = Class.forName(id);
                return (BundleResolver)resolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to create bundle resolver '%1$s'.", id), e));
            }
        }
        throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Unknown bundle resolver '%1$s'.", id)));
    }

    public static BundleEntryProvider detectEntryProvider(Class<?> refClass, @Nullable List<Path> expliciteBaseDirectories) throws StatusException {
        String refUrl = null;
        try {
            refUrl = ClassLoaderUtils.getClassLocationUrlString(refClass);
            return Bundles.detectEntryProvider(refUrl, expliciteBaseDirectories);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to autodetect bundle location\n\tclass= %1$s\n\turl= %2$s", refClass != null ? refClass.getName() : "<NA>", refUrl != null ? String.valueOf('\'') + refUrl + '\'' : "<NA>"), e));
        }
    }

    public static BundleEntryProvider detectEntryProvider(Class<?> refClass) throws StatusException {
        return Bundles.detectEntryProvider(refClass, null);
    }

    public static BundleEntryProvider detectEntryProvider(String refUrl) throws StatusException {
        try {
            return Bundles.detectEntryProvider(refUrl, null);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to autodetect bundle location\n\turl= %1$s", refUrl != null ? String.valueOf('\'') + refUrl + '\'' : "<NA>"), e));
        }
    }

    public static BundleEntry detectEntry(Class<?> refClass) throws StatusException {
        String refUrl = null;
        try {
            refUrl = ClassLoaderUtils.getClassLocationUrlString(refClass);
            return Bundles.detectEntry(refUrl);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to autodetect bundle location\n\tclass= %1$s\n\turl= %2$s", refClass != null ? refClass.getName() : "<NA>", refUrl != null ? String.valueOf('\'') + refUrl + '\'' : "<NA>"), e));
        }
    }

    static BundleEntryProvider detectEntryProvider(String refUrl, @Nullable List<Path> expliciteBaseDirectories) throws Exception {
        ImList<Closeable> closeables = ImCollections.emptyList();
        try {
            Matcher matcher = AUTODETECT_PATTERN.matcher(refUrl);
            if (matcher.matches()) {
                BundleEntryProvider provider;
                URI detectedBaseUri;
                int detectedType;
                if (matcher.start(1) != -1) {
                    detectedType = 1;
                    s = ObjectUtils.nonNullAssert(matcher.group(1));
                    detectedBaseUri = new URI(s);
                } else if (matcher.start(3) != -1) {
                    detectedType = 2;
                    s = ObjectUtils.nonNullAssert(matcher.group(3));
                    detectedBaseUri = s.indexOf("!/") == -1 ? new URI(s.substring(4)) : new URI(s);
                } else {
                    throw new IllegalStateException();
                }
                Path detectedBaseDirectory = Bundles.getPath(detectedBaseUri);
                ArrayList<Path> uniqueList = new ArrayList<Path>();
                if (expliciteBaseDirectories != null && !expliciteBaseDirectories.isEmpty()) {
                    for (Path baseDirectory : expliciteBaseDirectories) {
                        if (uniqueList.contains(baseDirectory = baseDirectory.normalize())) continue;
                        uniqueList.add(baseDirectory);
                    }
                }
                if (!uniqueList.contains(detectedBaseDirectory)) {
                    uniqueList.add(detectedBaseDirectory);
                }
                ImList<Path> baseDirectories = ImCollections.toList(uniqueList);
                if (detectedType == 1) {
                    provider = new BundleEntryProvider.DevBinPathEntryProvider(baseDirectories, closeables);
                } else {
                    Pattern fileNamePattern = matcher.start(5) != -1 ? JAR_VER_1_PATTERN : (matcher.start(6) != -1 ? JAR_VER_2_PATTERN : JAR_VER_0_PATTERN);
                    provider = new BundleEntryProvider.JarFilePathEntryProvider(baseDirectories, fileNamePattern, closeables);
                }
                closeables = null;
                BundleEntryProvider.DevBinPathEntryProvider devBinPathEntryProvider = provider;
                return devBinPathEntryProvider;
            }
            throw new UnsupportedOperationException("url= " + refUrl);
        }
        finally {
            if (closeables != null) {
                Bundles.close(closeables);
            }
        }
    }

    static BundleEntry detectEntry(String refUrl) throws Exception {
        ImList<Closeable> closeables = ImCollections.emptyList();
        try {
            Matcher matcher = AUTODETECT_PATTERN.matcher(refUrl);
            if (matcher.matches()) {
                BundleEntryProvider provider;
                String fileName;
                URI detectedBaseUri;
                int detectedType;
                if (matcher.start(1) != -1) {
                    detectedType = 1;
                    s = ObjectUtils.nonNullAssert(matcher.group(1));
                    detectedBaseUri = new URI(s);
                    fileName = ObjectUtils.nonNullAssert(matcher.group(2));
                } else if (matcher.start(3) != -1) {
                    detectedType = 2;
                    s = ObjectUtils.nonNullAssert(matcher.group(3));
                    detectedBaseUri = s.indexOf("!/") == -1 ? new URI(s.substring(4)) : new URI(s);
                    fileName = ObjectUtils.nonNullAssert(matcher.group(4));
                } else {
                    throw new IllegalStateException();
                }
                Path detectedBaseDirectory = Bundles.getPath(detectedBaseUri);
                ImList<Path> baseDirectories = ImCollections.newList(detectedBaseDirectory);
                if (detectedType == 1) {
                    provider = new BundleEntryProvider.DevBinPathEntryProvider(baseDirectories, closeables);
                } else {
                    Pattern fileNamePattern = matcher.start(5) != -1 ? JAR_VER_1_PATTERN : (matcher.start(6) != -1 ? JAR_VER_2_PATTERN : JAR_VER_0_PATTERN);
                    provider = new BundleEntryProvider.JarFilePathEntryProvider(baseDirectories, fileNamePattern, closeables);
                }
                closeables = null;
                BundleEntry bundleEntry = ObjectUtils.nonNullAssert(((BundleEntryProvider)provider).createEntry(((Path)baseDirectories.get(0)).resolve(fileName)));
                return bundleEntry;
            }
            throw new UnsupportedOperationException("url= " + refUrl);
        }
        finally {
            if (closeables != null) {
                Bundles.close(closeables);
            }
        }
    }

    static Path getPath(URI url) throws IOException {
        FileSystem fs = null;
        while (true) {
            try {
                Path path = Path.of(url);
                return path.normalize();
            }
            catch (FileSystemNotFoundException e) {
                HashMap fsEnv = new HashMap();
                try {
                    fs = FileSystems.newFileSystem(url, fsEnv);
                }
                catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                }
                continue;
            }
            break;
        }
    }

    static void close(List<Closeable> closeables) {
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", "An error occurred when disposing closable of path entry provider.", e));
            }
        }
    }

    private Bundles() {
    }
}

