/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public final class StringUtils {
    private static final byte[] U_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final Pattern U_LINEBREAK_PATTERN = Pattern.compile("\\R");
    private static final String STOP = new String("STOP");

    public static String formatCodePoint(int cp) {
        int nDigits = Math.max((39 - Integer.numberOfLeadingZeros(cp)) / 8 * 2, 4);
        byte[] latin1 = new byte[2 + nDigits];
        latin1[0] = 85;
        latin1[1] = 43;
        int i = latin1.length;
        do {
            latin1[--i] = U_DIGITS[cp & 0xF];
            cp >>>= 4;
        } while (i > 2);
        return new String(latin1, 0, 0, latin1.length);
    }

    /*
     * Unable to fully structure code
     */
    public static int firstIndexOfNonTrim(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl5:
        // 1 sources

        return start;
    }

    public static int firstIndexOfNonTrim(String s) {
        int start = 0;
        int end = s.length();
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        return start;
    }

    /*
     * Unable to fully structure code
     */
    public static int lastIndexOfNonTrim(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            --end;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)(end - 1)) <= ' ')
        }
lbl5:
        // 1 sources

        return end;
    }

    public static int lastIndexOfNonTrim(String s) {
        int end = s.length();
        while (end > 0 && s.charAt(end - 1) <= ' ') {
            --end;
        }
        return end;
    }

    /*
     * Unable to fully structure code
     */
    public static String trim(String s, int start, int end) {
        if (start < 0 || end > s.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        if (start != 0 || end != s.length()) ** GOTO lbl6
        return s.trim();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl6:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl7:
        // 2 sources

        while (start < end && s.charAt(end - 1) <= ' ') {
            --end;
        }
        return s.substring(start, end);
    }

    public static boolean isTrimEmpty(String s) {
        int start = 0;
        int end = s.length();
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        return start == end;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTrimEmpty(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl5:
        // 1 sources

        return start == end;
    }

    public static boolean containsAny(String s, ImCollection<String> searchStrings) {
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            if (s.indexOf(searchString) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(StringBuilder s, ImCollection<String> searchStrings) {
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            if (s.indexOf(searchString) < 0) continue;
            return true;
        }
        return false;
    }

    public static int firstIndexOfAny(String s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString, fromIndex);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(String s, ImCollection<String> searchStrings) {
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(StringBuilder s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString, fromIndex);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(StringBuilder s, ImCollection<String> searchStrings) {
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static @Nullable Match firstMatchOfAny(String s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || !s.startsWith(searchString, matchIndex)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString, fromIndex);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(String s, ImCollection<String> searchStrings) {
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || !s.startsWith(searchString, matchIndex)) continue;
                matchString = searchString;
                continue;
            }
            int index = s.indexOf(searchString);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(StringBuilder s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || matchIndex + searchString.length() > s.length() || !s.substring(matchIndex, matchIndex + searchString.length()).equals(searchString)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString, fromIndex);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(StringBuilder s, ImCollection<String> searchStrings) {
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || matchIndex + searchString.length() > s.length() || !s.substring(matchIndex, matchIndex + searchString.length()).equals(searchString)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static void collectLines(String s, Collection<String> lines) {
        int n = s.length();
        int idx = 0;
        int lineStartIdx = 0;
        while (idx < n) {
            switch (s.charAt(idx)) {
                case '\r': {
                    lines.add(s.substring(lineStartIdx, idx++));
                    if (idx >= n || s.charAt(idx) == '\n') {
                        // empty if block
                    }
                    lineStartIdx = ++idx;
                    break;
                }
                case '\n': {
                    lines.add(s.substring(lineStartIdx, idx++));
                    lineStartIdx = idx;
                    break;
                }
                default: {
                    ++idx;
                }
            }
        }
        if (lineStartIdx < n) {
            lines.add(s.substring(lineStartIdx, n));
        }
    }

    public static List<String> linesToList(String s) {
        ArrayList<String> lines = new ArrayList<String>(2 + s.length() / 20);
        StringUtils.collectLines(s, lines);
        return lines;
    }

    public static String toSimpleSingleLine(String text) {
        int length = text.length();
        StringBuilder escaped = null;
        int idxWritten = 0;
        int idx = 0;
        block6: while (idx < length) {
            String replacement;
            char c = text.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u001b': 
                case '\u001c': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': 
                case '\u0080': 
                case '\u0081': 
                case '\u0082': 
                case '\u0083': 
                case '\u0084': 
                case '\u0085': 
                case '\u0086': 
                case '\u0087': 
                case '\u0088': 
                case '\u0089': 
                case '\u008a': 
                case '\u008b': 
                case '\u008c': 
                case '\u008d': 
                case '\u008e': 
                case '\u008f': 
                case '\u0090': 
                case '\u0091': 
                case '\u0092': 
                case '\u0093': 
                case '\u0094': 
                case '\u0095': 
                case '\u0096': 
                case '\u0097': 
                case '\u0098': 
                case '\u0099': 
                case '\u009a': 
                case '\u009b': 
                case '\u009c': 
                case '\u009d': 
                case '\u009e': 
                case '\u009f': {
                    replacement = null;
                    break;
                }
                case '\t': {
                    replacement = "  ";
                    break;
                }
                case '\n': {
                    replacement = idx < length - 1 ? " \u2014 " : STOP;
                    break;
                }
                case '\f': {
                    replacement = STOP;
                    break;
                }
                default: {
                    ++idx;
                    continue block6;
                }
            }
            if (replacement == STOP) {
                if (escaped == null) {
                    return text.substring(0, idx);
                }
                if (idx > idxWritten) {
                    escaped.append(text, idxWritten, idx);
                }
                return escaped.toString();
            }
            if (escaped == null) {
                escaped = new StringBuilder(length + 16);
            }
            if (idx > idxWritten) {
                escaped.append(text, idxWritten, idx);
            }
            if (replacement != null) {
                escaped.append(replacement);
            }
            idxWritten = ++idx;
        }
        if (escaped == null) {
            return text;
        }
        if (length > idxWritten) {
            escaped.append(text, idxWritten, length);
        }
        return escaped.toString();
    }

    private StringUtils() {
    }

    public static final class Match {
        private final String string;
        private final int startIndex;

        public Match(String string, int startIndex) {
            this.string = ObjectUtils.nonNullAssert(string);
            this.startIndex = startIndex;
        }

        public String getString() {
            return this.string;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.startIndex + this.string.length();
        }

        public int getLength() {
            return this.string.length();
        }
    }
}

