/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.assist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public final class PositionBasedCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2 {
    private final String replacementString;
    private final Position replacementPosition;
    private final @Nullable String displayString;
    private final @Nullable Image image;
    private final @Nullable String additionalProposalInfo;
    private final int cursorPosition;
    private final @Nullable IContextInformation contextInformation;

    public PositionBasedCompletionProposal(String replacementString, Position replacementPosition, int cursorPosition, @Nullable Image image, @Nullable String displayString, @Nullable IContextInformation contextInformation, @Nullable String additionalProposalInfo) {
        this.replacementString = (String)ObjectUtils.nonNullAssert((Object)replacementString);
        this.replacementPosition = (Position)ObjectUtils.nonNullAssert((Object)replacementPosition);
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public PositionBasedCompletionProposal(String replacementString, Position replacementPosition, int cursorPosition) {
        this(replacementString, replacementPosition, cursorPosition, null, null, null, null);
    }

    @Deprecated
    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public boolean validate(IDocument document, int offset, @Nullable DocumentEvent event) {
        try {
            String content = document.get(this.replacementPosition.getOffset(), offset - this.replacementPosition.getOffset());
            return this.replacementString.startsWith(content);
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public @Nullable Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        return (String)ObjectUtils.nonNullElse((Object)this.displayString, (Object)this.replacementString);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public @Nullable String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public char @Nullable [] getTriggerCharacters() {
        return null;
    }

    @Deprecated
    public void apply(IDocument document, char trigger, int offset) {
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementPosition.getOffset(), this.replacementPosition.getLength(), this.replacementString);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply((IDocument)ObjectUtils.nonNullAssert((Object)viewer.getDocument()));
    }

    public @Nullable Point getSelection(IDocument document) {
        return new Point(this.replacementPosition.getOffset() + this.cursorPosition, 0);
    }

    public @Nullable IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public int getContextInformationPosition() {
        return this.replacementPosition.getOffset();
    }
}

