/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.rmodel.RModelEventJob;
import org.eclipse.statet.internal.r.core.rmodel.RModelIndex;
import org.eclipse.statet.internal.r.core.rmodel.RReconciler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.build.SourceUnitModelContainer;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelManager;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.rmodel.RChunkElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RModelManager;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.rmodel.build.RSourceUnitModelContainer;
import org.eclipse.statet.r.core.source.ast.SourceComponent;

@NonNullByDefault
public class RModelManagerImpl
extends AbstractModelManager
implements RModelManager {
    private final RReconciler reconciler = new RReconciler(this);
    private final RModelEventJob eventJob = new RModelEventJob(this);
    private final RModelIndex index = new RModelIndex(this);

    public RModelManagerImpl() {
        super("R");
    }

    public void dispose() {
        this.eventJob.dispose();
        this.index.dispose();
    }

    public RModelEventJob getEventJob() {
        return this.eventJob;
    }

    public RModelIndex getIndex() {
        return this.index;
    }

    protected AbstractModelManager.ContextItem doCreateContextItem(WorkingContext context) {
        return new RContextItem(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependentUnit(SourceUnit copy) {
        RContextItem contextItem;
        assert (!copy.getModelTypeId().equals("R") || copy.getElementType() == 531);
        RContextItem rContextItem = contextItem = (RContextItem)this.getContextItemCreate(copy.getWorkingContext());
        synchronized (rContextItem) {
            String key = String.valueOf(copy.getId()) + '+' + copy.getModelTypeId();
            contextItem.worksheets.put(key, copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDependentUnit(SourceUnit copy) {
        RContextItem contextItem;
        RContextItem rContextItem = contextItem = (RContextItem)this.getContextItemCreate(copy.getWorkingContext());
        synchronized (rContextItem) {
            contextItem.worksheets.remove(String.valueOf(copy.getId()) + '+' + copy.getModelTypeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable SourceUnit getWorksheetCopy(String type, String id, WorkingContext context) {
        RContextItem contextItem = (RContextItem)this.getContextItem(context);
        if (contextItem != null) {
            RContextItem rContextItem = contextItem;
            synchronized (rContextItem) {
                return contextItem.worksheets.get(String.valueOf(id) + '+' + type);
            }
        }
        return null;
    }

    public void reconcile(SourceUnitModelContainer<?, ?> adapter, int level, IProgressMonitor monitor) {
        if (adapter instanceof RSourceUnitModelContainer) {
            this.reconciler.reconcile((RSourceUnitModelContainer)adapter, level, monitor);
        }
    }

    @Override
    public RSourceUnitModelInfo reconcile(RSourceUnit sourceUnit, SourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunks, List<? extends SourceComponent> inlineNodes, int level, IProgressMonitor monitor) {
        if (sourceUnit == null) {
            throw new NullPointerException("sourceUnit");
        }
        return this.reconciler.reconcile(sourceUnit, modelInfo, chunks, inlineNodes, level, monitor);
    }

    @Override
    public @Nullable RFrame getProjectFrame(RProject rProject) throws CoreException {
        return this.index.getProjectFrame(rProject);
    }

    @Override
    public Set<String> getPkgNames() {
        return this.index.getPkgNames();
    }

    @Override
    public @Nullable RFrame getPkgProjectFrame(String pkgName) throws CoreException {
        IProject project;
        RProjectNature rProject;
        if (pkgName == null) {
            throw new NullPointerException("pkgName");
        }
        String projectName = this.index.getPkgProject(pkgName);
        if (projectName != null && (rProject = RProjectNature.getRProject(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))) != null) {
            return this.getProjectFrame(rProject);
        }
        return null;
    }

    @Override
    public @Nullable List<SourceUnit> findReferencingSourceUnits(RProject rProject, RElementName name, IProgressMonitor monitor) throws CoreException {
        return this.index.findReferencingSourceUnits(rProject, name, monitor);
    }

    private static class RContextItem
    extends AbstractModelManager.ContextItem {
        public final HashMap<String, SourceUnit> worksheets = new HashMap();

        public RContextItem(WorkingContext context) {
            super(context);
        }
    }
}

