/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.statet.internal.r.debug.core.breakpoints.ExceptionBreakpointImpl;
import org.eclipse.statet.internal.r.debug.core.breakpoints.LineBreakpointImpl;
import org.eclipse.statet.internal.r.debug.core.breakpoints.MethodBreakpointImpl;
import org.eclipse.statet.internal.r.debug.core.eval.EvaluationExpression;
import org.eclipse.statet.internal.r.debug.core.eval.EvaluationResult;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.RDebugTarget;
import org.eclipse.statet.r.debug.core.REvaluationResult;
import org.eclipse.statet.r.debug.core.breakpoints.RExceptionBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RMethodBreakpoint;
import org.eclipse.statet.r.nico.AbstractRDbgController;

@NonNullByDefault
public class RDebugModel {
    public static final String IDENTIFIER = "org.eclipse.statet.r.debugModels.R";
    public static final String R_LINE_BREAKPOINT_TYPE_ID = "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint";
    public static final String R_METHOD_BREAKPOINT_TYPE_ID = "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint";
    public static final String R_EXCEPTION_BREAKPOINT_TYPE_ID = "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint";
    private static final List<RLineBreakpoint> NO_R_LINE_BREAKPOINTS = Collections.emptyList();

    public static RLineBreakpoint createLineBreakpoint(IFile resource, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel, boolean temporary) throws CoreException {
        return new LineBreakpointImpl((IResource)resource, lineNumber, charStart, charEnd, elementType, elementId, elementLabel, subLabel, temporary);
    }

    public static RMethodBreakpoint createMethodBreakpoint(IFile resource, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel, boolean temporary) throws CoreException {
        return new MethodBreakpointImpl((IResource)resource, lineNumber, charStart, charEnd, elementType, elementId, elementLabel, subLabel, temporary);
    }

    public static RExceptionBreakpoint createExceptionBreakpoint(String exceptionId, boolean temporary) throws CoreException {
        return new ExceptionBreakpointImpl((IResource)ResourcesPlugin.getWorkspace().getRoot(), exceptionId, temporary);
    }

    /*
     * WARNING - void declaration
     */
    public static List<RLineBreakpoint> getLineBreakpoints(IFile file) throws CoreException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(IDENTIFIER);
        List<RLineBreakpoint> matches = null;
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint iBreakpoint = breakpoints[i];
            if (iBreakpoint instanceof RLineBreakpoint) {
                void breakpoint;
                RLineBreakpoint cfr_ignored_0 = (RLineBreakpoint)iBreakpoint;
                RLineBreakpoint cfr_ignored_1 = (RLineBreakpoint)iBreakpoint;
                IMarker marker = breakpoint.getMarker();
                if (marker != null && marker.exists() && file.equals((Object)marker.getResource())) {
                    if (matches == null) {
                        matches = new ArrayList<RLineBreakpoint>(4);
                    }
                    matches.add((RLineBreakpoint)breakpoint);
                }
            }
            ++i;
        }
        return matches != null ? matches : NO_R_LINE_BREAKPOINTS;
    }

    /*
     * WARNING - void declaration
     */
    public static List<RLineBreakpoint> getLineBreakpoints(IFile file, int lineNumber) throws CoreException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(IDENTIFIER);
        List<RLineBreakpoint> matches = null;
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint iBreakpoint = breakpoints[i];
            if (iBreakpoint instanceof RLineBreakpoint) {
                void breakpoint;
                RLineBreakpoint cfr_ignored_0 = (RLineBreakpoint)iBreakpoint;
                RLineBreakpoint cfr_ignored_1 = (RLineBreakpoint)iBreakpoint;
                IMarker marker = breakpoint.getMarker();
                if (marker != null && marker.exists() && file.equals((Object)marker.getResource()) && lineNumber == breakpoint.getLineNumber()) {
                    if (matches == null) {
                        matches = new ArrayList<RLineBreakpoint>(4);
                    }
                    matches.add((RLineBreakpoint)breakpoint);
                }
            }
            ++i;
        }
        return matches != null ? matches : NO_R_LINE_BREAKPOINTS;
    }

    /*
     * WARNING - void declaration
     */
    public static @Nullable RExceptionBreakpoint getExpressionBreakpoint(String expressionId) throws DebugException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(IDENTIFIER);
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint iBreakpoint = breakpoints[i];
            if (iBreakpoint instanceof RExceptionBreakpoint) {
                void breakpoint;
                RExceptionBreakpoint cfr_ignored_0 = (RExceptionBreakpoint)iBreakpoint;
                RExceptionBreakpoint cfr_ignored_1 = (RExceptionBreakpoint)iBreakpoint;
                if (breakpoint.getExceptionId().equals(expressionId)) {
                    return breakpoint;
                }
            }
            ++i;
        }
        return null;
    }

    public static IErrorReportingExpression createExpression(REvaluationResult result) {
        return new EvaluationExpression((EvaluationResult)result);
    }

    public static RDebugTarget createRDebugTarget(AbstractRDbgController controller) {
        return new RDebugTargetImpl(controller);
    }
}

