/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.launching.ICodeSubmitContentHandler;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class SubmitFileDirectLaunchShortcut
implements ILaunchShortcut {
    private final boolean fGotoConsole;

    public SubmitFileDirectLaunchShortcut() {
        this(false);
    }

    protected SubmitFileDirectLaunchShortcut(boolean gotoConsole) {
        this.fGotoConsole = gotoConsole;
    }

    public void launch(ISelection selection, String mode) {
        assert (mode.equals("run"));
        try {
            IFile[] files = LTKSelectionUtils.getSelectedFiles((ISelection)selection);
            if (files != null) {
                int last = files.length - 1;
                int i = 0;
                while (i <= last) {
                    List<String> lines = LaunchShortcutUtil.getCodeLines(files[i]);
                    RCodeLaunching.runRCodeDirect(lines, i == last && this.fGotoConsole, null);
                    ++i;
                }
                return;
            }
            LaunchShortcutUtil.handleUnsupportedExecution(null);
        }
        catch (Exception e) {
            LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RScriptLaunch_error_message, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void launch(IEditorPart editor, String mode) {
        assert (mode.equals("run"));
        try {
            IEditorPart iEditorPart = editor;
            if (iEditorPart instanceof AbstractTextEditor) {
                void redt;
                AbstractTextEditor abstractTextEditor = (AbstractTextEditor)iEditorPart;
                AbstractTextEditor cfr_ignored_0 = (AbstractTextEditor)iEditorPart;
                ICodeSubmitContentHandler handler = RCodeLaunching.getCodeSubmitContentHandler(LTKWorkbenchUIUtil.getContentTypeId((IWorkbenchPart)redt));
                IDocument document = redt.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                List<String> lines = handler.getCodeLines(document);
                RCodeLaunching.runRCodeDirect(lines, this.fGotoConsole, null);
                return;
            }
            LaunchShortcutUtil.handleUnsupportedExecution(null);
        }
        catch (Exception e) {
            LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RScriptLaunch_error_message, null);
        }
    }
}

