/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.editors.RQuickOutlineInformationControl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.QuickInformationProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public class RQuickOutlineInformationProvider
extends QuickInformationProvider {
    private @Nullable RHeuristicTokenScanner scanner;

    public RQuickOutlineInformationProvider(RSourceEditor editor, int viewerOperation) {
        super((SourceEditor)editor, "R", viewerOperation);
    }

    public RSourceEditor getEditor() {
        return (RSourceEditor)super.getEditor();
    }

    private RHeuristicTokenScanner getScanner() {
        RHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = RHeuristicTokenScanner.create((DocContentSections)this.getEditor().getDocumentContentInfo());
        }
        return scanner;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        try {
            ITypedRegion partition;
            RHeuristicTokenScanner scanner = this.getScanner();
            IDocument document = (IDocument)ObjectUtils.nonNullAssert((Object)textViewer.getDocument());
            scanner.configure(document);
            IRegion word = scanner.findRWord(offset, false, true);
            if (word != null && (RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition = scanner.getPartition(word.getOffset())).getType()) || partition.getType() == "R.String" || partition.getType() == "R.QuotedSymbol")) {
                return word;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Region(offset, 0);
    }

    public IInformationControlCreator createInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new RQuickOutlineInformationControl(parent, RQuickOutlineInformationProvider.this.getCommandId());
            }
        };
    }
}

