/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.help;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.ICommandLink;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext3;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.help.Messages;
import org.eclipse.statet.internal.r.ui.rtools.RunHelpInR;
import org.eclipse.statet.internal.r.ui.rtools.RunHelpSearchInR;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.ui.IWorkbenchPart3;

public class EnrichedRHelpContext
implements IContext3 {
    private final String fTitle;
    private final String fText;
    private String fStyledText;
    private IHelpResource[] fRelatedTopics;
    private final ICommandLink[] fRelatedCommands;

    public static String searchContextInfo(Object target) {
        try {
            ISelectionProvider selectionProvider;
            SourceEditor editor;
            String plaintext = null;
            if (target instanceof IAdaptable && (editor = (SourceEditor)((IAdaptable)target).getAdapter(SourceEditor.class)) != null && (plaintext = EnrichedRHelpContext.getPlaintextFromTextSelection(selectionProvider = editor.getViewer().getSelectionProvider())) == null) {
                plaintext = EnrichedRHelpContext.getPlaintextFromDocument(editor.getViewer().getDocument(), editor.getDocumentContentInfo(), selectionProvider);
            }
            if (plaintext != null && plaintext.length() < 50 && plaintext.indexOf(10) < 0 && plaintext.indexOf(13) < 0) {
                return plaintext;
            }
        }
        catch (Exception e) {
            RUIPlugin.logError(100, "Error occured when dectecting R element", e);
        }
        return null;
    }

    private static String getPlaintextFromTextSelection(ISelectionProvider selectionProvider) {
        ITextSelection textSelection = (ITextSelection)selectionProvider.getSelection();
        if (!textSelection.isEmpty() && textSelection.getLength() > 0) {
            return textSelection.getText();
        }
        return null;
    }

    private static String getPlaintextFromDocument(IDocument document, DocContentSections contentInfo, ISelectionProvider selectionProvider) throws BadLocationException {
        ITextSelection textSelection = (ITextSelection)selectionProvider.getSelection();
        RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)contentInfo);
        scanner.configure(document);
        IRegion region = scanner.findRWord(textSelection.getOffset(), false, true);
        if (region != null) {
            return document.get(region.getOffset(), region.getLength());
        }
        return null;
    }

    public EnrichedRHelpContext(IContext3 context, String plaintext) {
        this.fTitle = context.getTitle();
        this.fText = context.getText();
        this.fStyledText = context.getStyledText();
        if (this.fStyledText == null) {
            this.fStyledText = this.fText;
        }
        this.fRelatedTopics = context.getRelatedTopics();
        this.fRelatedCommands = context.getRelatedCommands();
        this.enrich(plaintext);
    }

    private void enrich(String plaintext) {
        try {
            ArrayList<IHelpResource> resources = new ArrayList<IHelpResource>(this.fRelatedTopics.length + 1);
            String urlText = URLEncoder.encode(plaintext, "UTF-8");
            resources.add(new RHelpCommand(NLS.bind((String)Messages.RHelp_Run_Help_label, (Object)plaintext), MessageUtils.escapeForFormText((String)RunHelpInR.createCommandString(plaintext))));
            resources.add(new RHelpCommand(NLS.bind((String)Messages.RHelp_Run_HelpSearch_label, (Object)plaintext), MessageUtils.escapeForFormText((String)RunHelpSearchInR.createCommandString(plaintext))));
            resources.add(new RHelpResource(NLS.bind((String)Messages.RHelp_Search_RSiteSearch_label, (Object)plaintext), NLS.bind((String)"http://search.r-project.org/cgi-bin/namazu.cgi?query={0}&amp;max=20&amp;result=normal&amp;sort=score&amp;idxname=functions&amp;idxname=docs", (Object)urlText)));
            resources.addAll(Arrays.asList(this.fRelatedTopics));
            this.fRelatedTopics = resources.toArray(new IHelpResource[resources.size()]);
        }
        catch (Exception e) {
            RUIPlugin.logError(-1, "Error occured when enrich R help.", e);
        }
    }

    public String getTitle() {
        return this.fTitle;
    }

    public String getText() {
        return this.fText;
    }

    public String getStyledText() {
        return this.fStyledText;
    }

    public IHelpResource[] getRelatedTopics() {
        return this.fRelatedTopics;
    }

    public String getCategory(IHelpResource topic) {
        if (topic instanceof RHelpResource) {
            return Messages.RHelp_category;
        }
        return null;
    }

    public ICommandLink[] getRelatedCommands() {
        return this.fRelatedCommands;
    }

    public static class Provider
    implements IContextProvider {
        private final IWorkbenchPart3 fPart;
        private final ISourceViewer fSourceViewer;
        private final Object fTarget;
        private final String fContextId;

        public Provider(IWorkbenchPart3 part, String contextId) {
            this.fPart = part;
            this.fTarget = this.fPart;
            this.fContextId = contextId;
            this.fSourceViewer = null;
        }

        public Provider(ISourceViewer sourceViewer, String contextId) {
            this.fSourceViewer = sourceViewer;
            this.fTarget = this.fSourceViewer;
            this.fContextId = contextId;
            this.fPart = null;
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object target) {
            Object context = HelpSystem.getContext((String)this.fContextId);
            String plaintext = EnrichedRHelpContext.searchContextInfo(this.fTarget);
            if (context instanceof IContext3 && plaintext != null) {
                context = new EnrichedRHelpContext((IContext3)context, plaintext);
            }
            return context;
        }

        public String getSearchExpression(Object target) {
            return null;
        }
    }

    public static class RHelpCommand
    extends RHelpResource {
        public RHelpCommand(String label, String command) {
            super(label, "command://" + command);
        }
    }

    private static class RHelpResource
    implements IHelpResource {
        private final String fLabel;
        private final String fUrl;

        public RHelpResource(String label, String url) {
            this.fLabel = label;
            this.fUrl = url;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getHref() {
            return this.fUrl;
        }
    }
}

