/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.dataeditor;

import java.util.ArrayList;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataEditor;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.ts.core.AbstractRToolCommandHandler;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.ui.IWorkbenchPage;

@NonNullByDefault
public class ShowRElementCommandHandler
extends AbstractRToolCommandHandler {
    public static final String SHOW_ELEMENT_COMMAND_ID = "r/showElement";
    @Deprecated
    public static final String SHOW_ELEMENT_COMMAND_OLD_ID = "showElement";

    private static void doOpen(final RTool tool, final RElementName name) {
        UIAccess.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
                if (page == null) {
                    return;
                }
                RDataEditor.open(page, tool, name, null);
            }
        });
    }

    public Status execute(String id, RToolService r, ToolCommandData data, ProgressMonitor m) throws StatusException {
        switch (id) {
            case "showElement": 
            case "r/showElement": {
                RTool tool = r.getTool();
                String elementName = data.getStringRequired("elementName");
                RElementName rElementName = RElementName.parseDefault((String)elementName);
                if (rElementName != null) {
                    if (rElementName.getScope() != null) {
                        ShowRElementCommandHandler.doOpen(tool, rElementName);
                    } else {
                        tool.getQueue().addHot((ToolRunnable)new CheckRunnable(tool, rElementName));
                    }
                }
                return Status.OK_STATUS;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class CheckRunnable
    extends AbstractRToolRunnable
    implements SystemRunnable {
        private final RTool tool;
        private final RElementName elementName;

        public CheckRunnable(RTool tool, RElementName elementName) {
            super("r/dataeditor/open", "Show R Element");
            this.tool = tool;
            this.elementName = elementName;
        }

        public boolean canRunIn(Tool tool) {
            return tool == this.tool;
        }

        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
            }
            return true;
        }

        public void run(RToolService service, ProgressMonitor m) throws StatusException {
            FQRObject data = service.findData(this.elementName.getSegmentName(), null, true, "combined", 1, 0, m);
            if (data == null) {
                return;
            }
            RProcessREnvironment foundEnv = (RProcessREnvironment)data.getEnv();
            ArrayList<RElementName> segments = new ArrayList<RElementName>();
            segments.add(foundEnv.getElementName());
            RElementName.addSegments(segments, (RElementName)this.elementName);
            ShowRElementCommandHandler.doOpen(this.tool, RElementName.create(segments));
        }
    }
}

