/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.processing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingUI;
import org.eclipse.statet.docmlet.base.ui.processing.actions.RunDocConfigsMenuContribution;
import org.eclipse.statet.ecommons.debug.ui.config.actions.RunConfigsMenuContribution;
import org.eclipse.statet.internal.redocs.tex.r.ui.processing.TexRweaveConfig;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

@NonNullByDefault
public class TexRweaveConfigsMenuContribution
extends RunDocConfigsMenuContribution {
    private static final String PROCESS_TEX_COMMAND_ID = "org.eclipse.statet.docmlet.commands.ProcessTexDefault";

    protected RunConfigsMenuContribution.ConfigContribution createConfigContribution(StringBuilder label, Image icon, ILaunchConfiguration configuration) {
        return new ThisConfigContribution(label.toString(), icon, configuration);
    }

    private class ThisConfigContribution
    extends RunDocConfigsMenuContribution.DocConfigContribution {
        public ThisConfigContribution(String label, Image icon, ILaunchConfiguration configuration) {
            super((RunDocConfigsMenuContribution)TexRweaveConfigsMenuContribution.this, label, icon, configuration);
        }

        protected void addLaunchItems(Menu menu) {
            String buildDetail = null;
            String weaveDetail = null;
            String produceDetail = null;
            try {
                ILaunchConfiguration config = this.getConfiguration();
                IFile file = (IFile)this.getElement();
                String sourceInputExt = TexRweaveConfigsMenuContribution.this.resolveFormatExt(TexRweaveConfig.SOURCE_FORMAT, file.getFileExtension());
                boolean weaveEnabled = config.getAttribute("org.eclipse.statet.redocs/weave/Run.enabled", false);
                String weaveInputExt = sourceInputExt;
                String weaveOutputExt = TexRweaveConfigsMenuContribution.this.resolveFormatExt(TexRweaveConfig.getFormat(TexRweaveConfig.WEAVE_OUTPUT_FORMATS, null, (String)config.getAttribute("org.eclipse.statet.redocs/weave/Output.Format.key", null)), weaveInputExt);
                boolean produceEnabled = config.getAttribute("org.eclipse.statet.redocs/produce/Run.enabled", false);
                String produceInputExt = weaveEnabled ? weaveOutputExt : sourceInputExt;
                String produceOutputExt = TexRweaveConfigsMenuContribution.this.resolveFormatExt(TexRweaveConfig.getFormat(TexRweaveConfig.PRODUCE_OUTPUT_FORMATS, null, (String)config.getAttribute("org.eclipse.statet.redocs/produce/Output.Format.key", null)), produceInputExt);
                if (weaveEnabled | produceEnabled) {
                    buildDetail = this.createDetail(weaveEnabled ? weaveInputExt : produceInputExt, produceEnabled ? produceOutputExt : weaveOutputExt);
                }
                weaveDetail = this.createDetail(weaveInputExt, weaveOutputExt);
                produceDetail = this.createDetail(produceInputExt, produceOutputExt);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.addLaunchItem(menu, DocProcessingUI.CommonFlags.PROCESS_AND_PREVIEW, null, true, "org.eclipse.statet.docmlet.commands.ProcessAndPreviewDefault", "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfig");
            this.addLaunchItem(menu, DocProcessingUI.CommonFlags.PROCESS, buildDetail, buildDetail != null, "org.eclipse.statet.docmlet.commands.ProcessDocDefault", "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfigProcess");
            new MenuItem(menu, 2);
            this.addLaunchItem(menu, DocProcessingUI.CommonFlags.WEAVE, weaveDetail, weaveDetail != null, "org.eclipse.statet.redocs.commands.ProcessWeaveDefault", "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfigStep");
            this.addLaunchItem(menu, DocProcessingUI.CommonFlags.PRODUCE_OUTPUT, produceDetail, produceDetail != null, TexRweaveConfigsMenuContribution.PROCESS_TEX_COMMAND_ID, "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfigStep");
            this.addLaunchItem(menu, DocProcessingUI.CommonFlags.OPEN_OUTPUT, null, true, "org.eclipse.statet.docmlet.commands.PreviewDocDefault", "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfigPreview");
        }
    }
}

