/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;

public class RList32Impl
extends AbstractRObject
implements RList,
ExternalizableRObject {
    private int length;
    private RObject[] components;
    private String className1;
    private RCharacter32Store namesAttribute;

    public RList32Impl(RObject[] initialComponents, String[] initialNames) {
        this(initialComponents, "list", initialNames, initialComponents.length);
    }

    public RList32Impl(RObject[] initialComponents, String className1, String[] initialNames) {
        this(initialComponents, className1, initialNames, initialComponents.length);
    }

    public RList32Impl(RObject[] initialComponents, String className1, String[] initialNames, int length) {
        this.length = length;
        this.components = initialComponents;
        this.className1 = className1;
        if (initialNames == null && initialComponents != null) {
            initialNames = new String[length];
        }
        this.namesAttribute = initialNames != null ? this.createNamesStore(initialNames) : null;
    }

    protected RCharacter32Store createNamesStore(@Nullable String[] names) {
        return new RCharacter32Store(names, this.length);
    }

    public RList32Impl(RObject[] initialComponents, RCharacter32Store initialNames) {
        this.components = initialComponents;
        this.length = this.components.length;
        this.namesAttribute = initialNames;
    }

    public RList32Impl(RJIO io, RObjectFactory factory, int options) throws IOException {
        this.className1 = (options & 0x10) != 0 ? io.readString() : (this.getRObjectType() == 6 ? "data.frame" : "list");
        int l = this.length = RList32Impl.checkShortLength(io.readVULong((byte)(options & 7)));
        if ((options & 0x20) != 0) {
            this.namesAttribute = null;
            this.components = null;
        } else {
            this.namesAttribute = (RCharacter32Store)factory.readNames(io, l);
            this.components = new RObject[l];
            int i = 0;
            while (i < l) {
                this.components[i] = factory.readObject(io);
                ++i;
            }
        }
        if ((options & 8) != 0) {
            this.setAttributes(factory.readAttributeList(io));
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        this.doWriteExternal(io, factory, 0);
    }

    protected final void doWriteExternal(RJIO io, RObjectFactory factory, int options) throws IOException {
        RList attributes;
        int l = this.length;
        options |= io.getVULongGrade(l);
        if (!this.className1.equals(this.getDefaultRClassName())) {
            options |= 0x10;
        }
        RList rList = attributes = (io.flags & 2) != 0 ? this.getAttributes() : null;
        if (attributes != null) {
            options |= 8;
        }
        if (this.components == null) {
            options |= 0x20;
        }
        io.writeInt(options);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        io.writeVULong((byte)(options & 7), l);
        if ((options & 0x20) == 0) {
            factory.writeNames(this.namesAttribute, io);
            int i = 0;
            while (i < l) {
                factory.writeObject(this.components[i], io);
                ++i;
            }
        }
        if (attributes != null) {
            factory.writeAttributeList(attributes, io);
        }
    }

    @Override
    public byte getRObjectType() {
        return 7;
    }

    protected String getDefaultRClassName() {
        return "list";
    }

    @Override
    public final String getRClassName() {
        return this.className1;
    }

    protected int length() {
        return this.length;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public final RCharacterStore getNames() {
        return this.namesAttribute;
    }

    @Override
    public final String getName(int idx) {
        if (this.namesAttribute != null) {
            return this.namesAttribute.getChar(idx);
        }
        return null;
    }

    @Override
    public final String getName(long idx) {
        if (this.namesAttribute != null) {
            return this.namesAttribute.getChar(idx);
        }
        return null;
    }

    @Override
    public final RObject get(int idx) {
        return this.components[idx];
    }

    @Override
    public final RObject get(long idx) {
        if (idx < 0L || idx >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.components[(int)idx];
    }

    @Override
    public final RObject get(String name) {
        int idx;
        if (this.namesAttribute != null && (idx = this.namesAttribute.indexOf(name, 0)) >= 0) {
            return this.components[idx];
        }
        return null;
    }

    @Override
    public final RStore<?> getData() {
        return null;
    }

    public boolean set(int idx, RObject component) {
        this.components[idx] = component;
        return true;
    }

    public final boolean set(String name, RObject component) {
        if (component == null) {
            throw new NullPointerException();
        }
        int idx = this.namesAttribute.indexOf(name, 0);
        if (idx >= 0) {
            this.set(idx, component);
            return true;
        }
        return false;
    }

    public void insert(int idx, String name, RObject component) {
        if (component == null) {
            throw new NullPointerException();
        }
        int[] idxs = new int[]{idx};
        this.components = RList32Impl.prepareInsert(this.components, this.length, idxs);
        ++this.length;
        if (name == null) {
            this.namesAttribute.insertNA(idxs);
        } else {
            this.namesAttribute.insertChar(idx, name);
        }
    }

    public void add(String name, RObject component) {
        this.insert(this.length, name, component);
    }

    public void remove(int idx) {
        int[] idxs = new int[]{idx};
        this.components = RList32Impl.remove(this.components, this.length, idxs);
        --this.length;
        this.namesAttribute.remove(idxs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=RList, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.length);
        if (this.components != null) {
            sb.append("\n\tdata: ");
            int i = 0;
            while (i < this.length) {
                if (i > 100) {
                    sb.append("\n... ");
                    break;
                }
                if (this.namesAttribute == null || this.namesAttribute.isNA(i)) {
                    sb.append("\n[[").append(i + 1).append("]]\n");
                } else {
                    sb.append("\n$").append(this.namesAttribute.getChar(i)).append("\n");
                }
                sb.append(this.components[i]);
                ++i;
            }
        } else {
            sb.append("\n<NODATA/>");
        }
        return sb.toString();
    }
}

