/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics.comclient;

import org.eclipse.statet.ecommons.collections.IntArrayMap;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.rj.eclient.graphics.comclient.ToolRClientGraphicActions;
import org.eclipse.statet.rj.server.client.AbstractRJComClient;
import org.eclipse.statet.rj.server.client.AbstractRJComClientGraphicActions;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.statet.rj.ts.core.RToolService;

public class ERClientGraphicActions
extends AbstractRJComClientGraphicActions
implements ToolRClientGraphicActions {
    private final RTool tool;
    private final IntArrayMap<Boolean> resizeTasks = new IntArrayMap();
    private final IntArrayMap<Boolean> closeTasks = new IntArrayMap();

    public ERClientGraphicActions(AbstractRJComClient rjs, RTool tool) {
        super(rjs);
        this.tool = tool;
    }

    @Override
    public RTool getRHandle() {
        return this.tool;
    }

    public String getRLabel() {
        return this.tool.getLabel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status resizeGraphic(int devId, Runnable beforeResize) {
        IntArrayMap<Boolean> intArrayMap = this.resizeTasks;
        synchronized (intArrayMap) {
            if (this.resizeTasks.put(devId, (Object)Boolean.TRUE) == Boolean.TRUE) {
                return Status.OK_STATUS;
            }
        }
        return this.tool.getQueue().add((ToolRunnable)new ResizeRunnable(devId, beforeResize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status closeGraphic(int devId) {
        IntArrayMap<Boolean> intArrayMap = this.closeTasks;
        synchronized (intArrayMap) {
            if (this.closeTasks.put(devId, (Object)Boolean.TRUE) == Boolean.TRUE) {
                return Status.OK_STATUS;
            }
        }
        return this.tool.getQueue().add((ToolRunnable)new CloseRunnable(devId));
    }

    private class CloseRunnable
    extends AbstractRToolRunnable
    implements SystemRunnable {
        private final int devId;

        public CloseRunnable(int devId) {
            super("r/rj/gd/close", "Close R Graphic (" + (devId + 1) + ")");
            this.devId = devId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: 
                case 336: 
                case 340: 
                case 344: {
                    IntArrayMap<Boolean> intArrayMap = ERClientGraphicActions.this.closeTasks;
                    synchronized (intArrayMap) {
                        ERClientGraphicActions.this.closeTasks.put(this.devId, (Object)Boolean.FALSE);
                    }
                    return true;
                }
            }
            return true;
        }

        public void run(RToolService r, ProgressMonitor m) throws StatusException {
            ERClientGraphicActions.this.doCloseGraphic(this.devId, m);
        }
    }

    private class ResizeRunnable
    extends AbstractRToolRunnable
    implements SystemRunnable {
        private final int devId;
        private final Runnable beforeResize;

        public ResizeRunnable(int devId, Runnable beforeResize) {
            super("r/rj/gd/resize", "Resize R Graphic");
            this.devId = devId;
            this.beforeResize = beforeResize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool process) {
            switch (event) {
                case 288: 
                case 289: {
                    return false;
                }
                case 290: {
                    IntArrayMap<Boolean> intArrayMap = ERClientGraphicActions.this.closeTasks;
                    synchronized (intArrayMap) {
                        ERClientGraphicActions.this.resizeTasks.put(this.devId, (Object)Boolean.FALSE);
                    }
                    return true;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(RToolService r, ProgressMonitor m) throws StatusException {
            IntArrayMap<Boolean> intArrayMap = ERClientGraphicActions.this.closeTasks;
            synchronized (intArrayMap) {
                ERClientGraphicActions.this.resizeTasks.put(this.devId, (Object)Boolean.FALSE);
            }
            this.beforeResize.run();
            ERClientGraphicActions.this.doResizeGraphic(this.devId, m);
        }
    }
}

