/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.Operation;
import org.eclipse.statet.rj.server.dbg.FrameRef;

@NonNullByDefault
public abstract class DbgRequest
implements Operation,
RJIOExternalizable {
    public static final byte RESUME = 9;
    public static final byte STEP_INTO = 10;
    public static final byte STEP_OVER = 12;
    public static final byte STEP_RETURN = 14;
    private static final int FRAME_POSITION = 1;
    private static final int FRAME_HANDLE = 2;

    public static class Resume
    extends DbgRequest
    implements Operation.SyncOp {
        public Resume() {
        }

        public Resume(RJIO in) throws IOException {
        }

        public void writeExternal(RJIO out) throws IOException {
        }

        @Override
        public byte getOp() {
            return 9;
        }
    }

    public static class StepInto
    extends DbgRequest
    implements Operation.SyncOp {
        public StepInto() {
        }

        public StepInto(RJIO in) throws IOException {
        }

        public void writeExternal(RJIO out) throws IOException {
        }

        @Override
        public byte getOp() {
            return 10;
        }
    }

    public static class StepOver
    extends DbgRequest
    implements Operation.SyncOp {
        public StepOver() {
        }

        public StepOver(RJIO in) throws IOException {
        }

        public void writeExternal(RJIO out) throws IOException {
        }

        @Override
        public byte getOp() {
            return 12;
        }
    }

    public static class StepReturn
    extends DbgRequest
    implements Operation.SyncOp {
        private final int detail;
        private final RJIOExternalizable target;

        public StepReturn(FrameRef target) {
            if (target instanceof FrameRef.ByPosition) {
                this.detail = 1;
            } else if (target instanceof FrameRef.ByHandle) {
                this.detail = 2;
            } else {
                throw new IllegalArgumentException("target");
            }
            this.target = target;
        }

        public StepReturn(RJIO in) throws IOException {
            this.detail = in.readInt();
            switch (this.detail & 0xF) {
                case 1: {
                    this.target = new FrameRef.ByPosition(in);
                    break;
                }
                case 2: {
                    this.target = new FrameRef.ByHandle(in);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
        }

        public void writeExternal(RJIO out) throws IOException {
            out.writeInt(this.detail);
            this.target.writeExternal(out);
        }

        @Override
        public byte getOp() {
            return 14;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

