/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.emf.core.IContext;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MenuUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.rtm.base.ui.RtModelUIPlugin;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprDropAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.base.util.RExprType;
import org.eclipse.statet.rtm.base.util.RExprTypes;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class RExprWidget
extends Composite
implements IObjValueWidget<RTypedExpr> {
    private static final RParser DISPLAY_R_PARSER = new RParser(4);
    public static final int MIN_SIZE = 256;
    private static int DELAY_MS = 333;
    private final int options;
    private final RExprTypes types;
    private final List<TypeDef> typeDefs;
    private IContext context;
    private boolean withDetail;
    private TypeDef currentTypeDef;
    private SWTListener mainListener;
    private Label typeControl;
    private Menu typeMenu;
    private Text textControl;
    private Control detailControl;
    private Color typeBorder2Color;
    private Color typeBorderColor;
    private Color typeHoverColor;
    private int textWidthHint;
    private RTypedExpr currentValue;
    private ObjValueEvent<RTypedExpr> nextEvent;
    private long nextEventTime;
    private final Runnable nextEventRunnable = new Runnable(){

        @Override
        public void run() {
            if (RExprWidget.this.nextEventTime == 0L) {
                return;
            }
            long diff = (System.nanoTime() - (long)DELAY_MS * 1000000L - RExprWidget.this.nextEventTime) / 1000000L;
            if (diff < (long)(-(DELAY_MS / 10))) {
                RExprWidget.this.getDisplay().timerExec(-((int)diff), RExprWidget.this.nextEventRunnable);
                return;
            }
            RExprWidget.this.fireValueChanged();
        }
    };
    private final CopyOnWriteIdentityListSet<IObjValueListener<RTypedExpr>> listeners = new CopyOnWriteIdentityListSet();
    private int ignoreChanges;

    protected static final RParser getDisplayRParser() {
        return DISPLAY_R_PARSER;
    }

    public RExprWidget(Composite parent, int options, RExprTypes types, List<RExprTypeUIAdapter> uiAdapters) {
        super(parent, 0);
        if (uiAdapters == null) {
            throw new NullPointerException("uiAdapters");
        }
        this.options = options;
        this.types = types;
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>(uiAdapters.size());
        for (RExprTypeUIAdapter adapter : uiAdapters) {
            TypeDef typeDef = adapter.createWidgetDef();
            typeDefs.add(typeDef);
            if (!typeDef.hasDetail()) continue;
            this.withDetail = true;
        }
        this.typeDefs = typeDefs;
        this.createContent(this, uiAdapters);
    }

    public Control getControl() {
        return this;
    }

    public Text getText() {
        return this.textControl;
    }

    public Class<RTypedExpr> getValueType() {
        return RTypedExpr.class;
    }

    protected void createContent(Composite composite, List<RExprTypeUIAdapter> uiAdapters) {
        SWTListener listener;
        this.mainListener = listener = new SWTListener();
        this.addListener(11, listener);
        this.addListener(12, listener);
        this.typeControl = new Label(composite, 0x1000000);
        this.typeControl.addListener(6, (Listener)listener);
        this.typeControl.addListener(7, (Listener)listener);
        this.typeControl.addListener(3, (Listener)listener);
        this.typeControl.addListener(1, (Listener)listener);
        this.typeControl.addListener(9, (Listener)listener);
        this.typeControl.setSize(this.typeControl.computeSize(20, 16));
        this.textControl = new Text(composite, 0x2000800);
        this.textControl.addListener(1, (Listener)listener);
        this.textControl.addListener(15, (Listener)listener);
        this.textControl.addListener(16, (Listener)listener);
        this.textControl.addListener(24, (Listener)listener);
        this.textWidthHint = LayoutUtils.hintWidth((Text)this.textControl, null, (int)25);
        DropTarget dropTarget = new DropTarget((Control)this.textControl, 1);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new RExprDropAdapter(uiAdapters){

            @Override
            protected IContext getContext() {
                return RExprWidget.this.context;
            }

            @Override
            protected String getCurrentTypeKey() {
                return RExprWidget.this.currentTypeDef.getTypeKey();
            }

            @Override
            protected boolean insertText(String text) {
                RExprWidget.this.textControl.insert(text);
                return true;
            }

            @Override
            protected boolean setExpr(String typeKey, String expr, int time) {
                TypeDef typeDef = RExprWidget.this.getTypeDef(typeKey);
                if (typeDef != null) {
                    RExprWidget.this.doSetValue(typeDef, expr, time);
                    return true;
                }
                return false;
            }
        });
    }

    public void setContext(IContext context) {
        this.context = context;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textControl.setFont(font);
        this.textWidthHint = LayoutUtils.hintWidth((Text)this.textControl, null, (int)25);
    }

    public void setTypeBackgroundColor(Color color) {
        this.typeControl.setBackground(color);
    }

    public void setTypeBorderColor(Color color) {
        this.typeBorderColor = color;
    }

    public void setTypeBorder2Color(Color color) {
        this.typeBorder2Color = color;
    }

    public void setTypeHoverColor(Color color) {
        this.typeHoverColor = color;
    }

    public boolean getShowDetail() {
        return this.withDetail;
    }

    public void setShowDetail(boolean enabled) {
        this.withDetail = enabled;
        this.updateLayout();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textControl.setEnabled(enabled);
        if (this.detailControl != null) {
            this.detailControl.setEnabled(enabled);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int detailWidth = this.textWidthHint / 2;
        int minTextWidth = this.textWidthHint / 3;
        int spacing = LayoutUtils.defaultHSpacing();
        Point typeSize = this.typeControl.getSize();
        int width = wHint == -1 ? ((this.options & 0x100) != 0 ? minTextWidth : this.textWidthHint) : Math.max(this.textWidthHint / 3, wHint - typeSize.x - detailWidth);
        Rectangle trim = this.computeTrim(0, 0, width + typeSize.x + spacing + detailWidth, Math.max(this.textControl.computeSize((int)width, (int)hHint).y, typeSize.y));
        return new Point(trim.width, trim.height);
    }

    protected void updateLayout() {
        int detailWidth = this.textWidthHint / 2;
        int minTextSize = this.textWidthHint / 3;
        int spacing = LayoutUtils.defaultHSpacing();
        Rectangle clientArea = this.getClientArea();
        Point typeSize = this.typeControl.getSize();
        int x = clientArea.x;
        boolean indent = false;
        this.typeControl.setBounds(x + 0, clientArea.y, typeSize.x, clientArea.height);
        x += ++typeSize.x;
        if (!this.withDetail) {
            this.textControl.setBounds(x, clientArea.y, Math.max(minTextSize, clientArea.width - typeSize.x), clientArea.height);
            return;
        }
        int textWidth = Math.max(minTextSize, clientArea.width - typeSize.x - detailWidth - spacing);
        this.textControl.setBounds(x, clientArea.y, textWidth, clientArea.height);
        x += textWidth + spacing;
        if (this.detailControl != null) {
            this.detailControl.setBounds(x, clientArea.y, Math.max(clientArea.width - x, 0), clientArea.height);
        }
    }

    public void decorateType(Event event, boolean hover) {
        Color blend;
        Color border;
        if (this.typeBorderColor == null || !this.isEnabled()) {
            return;
        }
        if (!hover && this.typeMenu != null && this.typeMenu.isVisible()) {
            hover = true;
        }
        GC gc = event.gc;
        Point size = this.typeControl.getSize();
        if (hover) {
            border = this.typeHoverColor;
            blend = this.typeBorder2Color;
            if (border == null) {
                border = this.typeBorderColor;
            }
        } else if (this.textControl.isFocusControl()) {
            border = this.typeBorderColor;
            blend = this.typeBorder2Color;
        } else {
            border = this.getDisplay().getSystemColor(19);
            blend = null;
        }
        if (this.textControl.getBorderWidth() > 2 && blend != null) {
            gc.setForeground(blend);
            gc.drawRectangle(1, 1, size.x - 3, size.y - 3);
        }
        gc.setForeground(border);
        gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
        gc.setAlpha(127);
        gc.drawPoint(1, 1);
        gc.drawPoint(1, size.y - 2);
        gc.setAlpha(63);
        gc.drawPoint(size.x - 2, 1);
        gc.drawPoint(size.x - 2, size.y - 2);
        gc.setForeground(this.getBackground());
        gc.setAlpha(63);
        gc.drawPoint(size.x - 1, 0);
        gc.drawPoint(size.x - 1, size.y - 1);
        gc.drawPoint(1, 0);
        gc.drawPoint(0, 1);
        gc.drawPoint(0, size.y - 2);
        gc.drawPoint(1, size.y - 1);
        gc.setAlpha(127);
        gc.drawPoint(0, 0);
        gc.drawPoint(0, size.y - 1);
    }

    protected void showTypeMenu() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.typeMenu == null) {
            this.typeMenu = new Menu((Control)this.typeControl);
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 22: {
                            if (RExprWidget.this.mainListener.typeHover) break;
                            RExprWidget.this.typeControl.redraw();
                            break;
                        }
                        case 23: {
                            RExprWidget.this.mainListener.ignoreMouse = event.time;
                            RExprWidget.this.typeControl.redraw();
                            break;
                        }
                    }
                }
            };
            this.typeMenu.addListener(22, listener);
            this.typeMenu.addListener(23, listener);
            this.fillTypeMenu(this.typeMenu);
        }
        MenuUtils.setPullDownPosition((Menu)this.typeMenu, (Control)this.typeControl);
        this.typeMenu.setVisible(true);
    }

    protected void fillTypeMenu(Menu menu) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RExprWidget.this.doSetValue((TypeDef)event.widget.getData(), null, event.time);
                RExprWidget.this.doFocus();
            }
        };
        for (TypeDef typeDef : this.typeDefs) {
            MenuItem menuItem = new MenuItem(menu, 16);
            RExprTypeUIAdapter uiAdapter = typeDef.getUIAdapter();
            menuItem.setImage(uiAdapter.getImage());
            menuItem.setText(uiAdapter.getLabel());
            menuItem.setData((Object)typeDef);
            menuItem.addSelectionListener((SelectionListener)listener);
            menuItem.setSelection(typeDef == this.currentTypeDef);
        }
    }

    protected void doSetValue(TypeDef typeDef, String expr, int time) {
        if (typeDef == null) {
            typeDef = this.getTypeDef(this.types.getDefaultTypeKey());
        }
        ++this.ignoreChanges;
        try {
            if (this.currentTypeDef == typeDef) {
                if (expr != null) {
                    this.textControl.setText(expr);
                }
            } else {
                if (this.currentTypeDef != null) {
                    this.fireValueChanged();
                    this.currentTypeDef.lastValue = this.currentValue != null ? this.currentValue.getExpr() : null;
                }
                this.currentTypeDef = typeDef;
                if (expr == null) {
                    if (typeDef != null) {
                        if (typeDef.lastValue != null) {
                            expr = typeDef.lastValue;
                        } else if (this.currentValue != null) {
                            expr = typeDef.getUIAdapter().adopt(this.currentValue.getTypeKey(), this.currentValue.getExpr());
                        }
                    }
                    if (expr == null) {
                        expr = "";
                    }
                }
                if (this.detailControl != null) {
                    this.detailControl.setVisible(false);
                }
                if (typeDef != null) {
                    RExprTypeUIAdapter uiAdapter = typeDef.getUIAdapter();
                    this.typeControl.setImage(uiAdapter.getImage());
                    this.typeControl.setToolTipText(uiAdapter.getLabel());
                    this.textControl.setText(expr);
                    if (this.withDetail) {
                        this.detailControl = typeDef.getDetailControl(this);
                        this.updateLayout();
                        if (this.detailControl != null) {
                            this.detailControl.setEnabled(this.getEnabled());
                            this.detailControl.setVisible(true);
                        }
                    }
                } else {
                    this.typeControl.setImage(null);
                    this.typeControl.setToolTipText(null);
                    this.detailControl = null;
                }
            }
        }
        finally {
            --this.ignoreChanges;
            this.checkValueChanged(time, false);
        }
    }

    protected void doFocus() {
        this.textControl.selectAll();
        this.textControl.setFocus();
    }

    protected void onDispose() {
        if (this.typeMenu != null) {
            this.typeMenu.dispose();
        }
    }

    protected TypeDef getTypeDef(String key) {
        for (TypeDef def : this.typeDefs) {
            if (def.getTypeKey() != key) continue;
            return def;
        }
        return null;
    }

    public void addValueListener(IObjValueListener<RTypedExpr> listener) {
        this.listeners.add(listener);
    }

    public void removeValueListener(IObjValueListener<RTypedExpr> listener) {
        this.listeners.remove(listener);
    }

    protected void checkValueChanged(int time, boolean delay) {
        if (this.ignoreChanges > 0) {
            return;
        }
        this.nextEvent = new ObjValueEvent((IObjValueWidget)this, time, 0, (Object)this.currentValue, (Object)this.doGetValue(), 0);
        if (this.currentTypeDef != null) {
            this.currentTypeDef.valueAboutToChange(this.nextEvent);
        }
        if (this.currentValue != null ? this.currentValue.equals(this.nextEvent.newValue) : this.nextEvent.newValue == null) {
            return;
        }
        if (delay) {
            boolean schedule = this.nextEventTime == 0L;
            this.nextEventTime = System.nanoTime();
            if (schedule) {
                this.getDisplay().timerExec(DELAY_MS, this.nextEventRunnable);
            }
        } else {
            this.fireValueChanged();
        }
    }

    protected void fireValueChanged() {
        this.nextEventTime = 0L;
        ObjValueEvent<RTypedExpr> event = this.nextEvent;
        if (event == null) {
            return;
        }
        this.nextEvent = null;
        this.currentValue = (RTypedExpr)event.newValue;
        for (IObjValueListener listener : this.listeners.toList()) {
            listener.valueChanged(event);
        }
    }

    protected RTypedExpr doGetValue() {
        String text = this.textControl.getText();
        if (this.currentTypeDef == null || text.isEmpty()) {
            return null;
        }
        return new RTypedExpr(this.currentTypeDef.getTypeKey(), text);
    }

    public RTypedExpr getValue(int idx) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        this.fireValueChanged();
        return this.currentValue;
    }

    public void setValue(int idx, RTypedExpr value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        if (value == null) {
            this.doSetValue(null, "", 0);
            return;
        }
        TypeDef def = this.getTypeDef(value.getTypeKey());
        if (def == null) {
            def = new TypeDef(new UndefinedAdapter(value.getTypeKey()));
        }
        this.doSetValue(def, value.getExpr(), 0);
    }

    private class SWTListener
    implements Listener {
        private boolean typeHover;
        private int ignoreMouse;

        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 11: {
                    RExprWidget.this.updateLayout();
                    return;
                }
                case 6: {
                    this.typeHover = true;
                    RExprWidget.this.typeControl.redraw();
                    return;
                }
                case 7: {
                    this.typeHover = false;
                    RExprWidget.this.typeControl.redraw();
                    return;
                }
                case 15: {
                    RExprWidget.this.typeControl.redraw();
                    return;
                }
                case 16: {
                    RExprWidget.this.typeControl.redraw();
                    RExprWidget.this.fireValueChanged();
                    return;
                }
                case 3: {
                    RExprWidget.this.doFocus();
                    if (event.button == 1 && event.time != this.ignoreMouse) {
                        RExprWidget.this.showTypeMenu();
                        return;
                    }
                    return;
                }
                case 1: {
                    if (event.character == '\r' || (event.stateMask & (SWT.MOD1 | SWT.MOD3 | SWT.MOD4)) != 0) {
                        RExprWidget.this.fireValueChanged();
                        return;
                    }
                    if (event.character == '+' && event.stateMask == SWT.MOD3) {
                        RExprWidget.this.showTypeMenu();
                        return;
                    }
                    return;
                }
                case 9: {
                    RExprWidget.this.decorateType(event, this.typeHover);
                    return;
                }
                case 24: {
                    RExprWidget.this.checkValueChanged(event.time, true);
                    return;
                }
                case 12: {
                    RExprWidget.this.onDispose();
                    return;
                }
            }
        }
    }

    public static class TypeDef
    implements IObjValueListener<RTypedExpr> {
        private final RExprTypeUIAdapter adapter;
        private Control control;
        private RExprWidget widget;
        private String lastValue;

        public TypeDef(RExprTypeUIAdapter type) {
            this.adapter = type;
        }

        public String getTypeKey() {
            return this.adapter.getType().getTypeKey();
        }

        public RExprTypeUIAdapter getUIAdapter() {
            return this.adapter;
        }

        private Control getDetailControl(RExprWidget widget) {
            if (this.widget != null && this.widget != widget) {
                throw new IllegalStateException();
            }
            if (this.control == null) {
                this.widget = widget;
                this.control = this.createDetailControl(widget);
            }
            return this.control;
        }

        public boolean hasDetail() {
            return false;
        }

        protected Control createDetailControl(Composite parent) {
            return null;
        }

        protected void activate(Text text) {
        }

        protected void deactivate(Text text) {
        }

        public void valueAboutToChange(ObjValueEvent<RTypedExpr> event) {
        }

        public void valueChanged(ObjValueEvent<RTypedExpr> event) {
        }

        protected IContext getContext() {
            return this.widget.context;
        }

        protected void setExpr(String expr) {
            this.widget.doSetValue(this.widget.currentTypeDef, expr, 0);
        }
    }

    private static class UndefinedAdapter
    extends RExprTypeUIAdapter {
        public UndefinedAdapter(String type) {
            super(new RExprType(type, -1, NLS.bind((String)"Unknown data type (''{0}'')", (Object)type)), RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-unknown"));
        }
    }
}

