/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rtm.ggplot.ui.editors;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.databinding.DetailContext;
import org.eclipse.statet.ecommons.emf.ui.forms.Detail;
import org.eclipse.statet.ecommons.emf.ui.forms.DetailStack;
import org.eclipse.statet.ecommons.emf.ui.forms.EFFormSection;
import org.eclipse.statet.ecommons.emf.ui.forms.EObjectListProperty;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.statet.internal.rtm.ggplot.ui.editors.LayerGeomCommonDetail;
import org.eclipse.statet.internal.rtm.ggplot.ui.editors.LayerNoSelectionDetail;
import org.eclipse.statet.rtm.ggplot.GGPlotPackage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class LayersSection
extends EFFormSection {
    private final EObjectListProperty layersProperty;
    private Details details;

    public LayersSection(IEFFormPage page, Composite parent) {
        super(page, parent, "Layers", null);
        EClass eClass = GGPlotPackage.Literals.GG_PLOT;
        this.layersProperty = new EObjectListProperty("Layers", null, eClass, (EStructuralFeature)GGPlotPackage.Literals.GG_PLOT__LAYERS);
        this.createClient();
    }

    protected void createContent(Composite composite) {
        IEFFormPage page = this.getPage();
        this.layersProperty.create(composite, page);
        ((GridData)this.layersProperty.getControl().getLayoutData()).verticalAlignment = 128;
    }

    protected DetailStack createDetails(Composite parent) {
        this.details = new Details(this.getPage(), parent);
        return this.details;
    }

    public void addBindings(IEMFEditContext context) {
        this.layersProperty.bind(context);
        DetailContext detailContext = new DetailContext(context, this.layersProperty.getSingleSelectionObservable());
        this.details.setContext((IEMFEditContext)detailContext);
        this.getSection().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IObservableValue selection = LayersSection.this.layersProperty.getSingleSelectionObservable();
                IObservableList layers = LayersSection.this.layersProperty.getPropertyObservable();
                if (selection.getValue() == null & !layers.isEmpty()) {
                    selection.setValue(layers.get(0));
                }
            }
        });
    }

    public ISelectionProvider getSelectionProvider() {
        return this.layersProperty.getSelectionProvider();
    }

    private static class Details
    extends DetailStack {
        public Details(IEFFormPage page, Composite parent) {
            super(page, parent);
        }

        protected Detail createDetail(EObject value) {
            if (value != null) {
                switch (value.eClass().getClassifierID()) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        return new LayerGeomCommonDetail(this, value.eClass());
                    }
                }
                return super.createDetail(value);
            }
            return new LayerNoSelectionDetail(this);
        }
    }
}

