/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.gr;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.Utf8Strings;
import org.eclipse.statet.rj.server.GDCmdItem;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RJ;
import org.eclipse.statet.rj.server.gr.RjsGraphicManager;

@NonNullByDefault
public final class RjsGraphic {
    public static final int STATE_CLOSED = -1;
    public static final int STATE_OPENED = 1;
    public static final int STATE_PAGED = 2;
    private final RJ rj = RJ.getInstance();
    private final RjsGraphicManager manager = (RjsGraphicManager)ObjectUtils.nonNullAssert((Object)this.rj.getGraphicManager());
    private final byte slot = this.rj.getCurrentSlot();
    private int devId;
    int state;
    private int cachedStrWidthChar;
    private double @Nullable [] cachedStrWidthCharResult;
    private byte @Nullable [] cachedStrWidthStr;
    private double @Nullable [] cachedStrWidthStrResult;

    public byte getSlot() {
        return this.slot;
    }

    public int getDevId() {
        return this.devId;
    }

    public int getState() {
        return this.state;
    }

    public void initPage(int devId, int state, double width, double height, int canvasColor, boolean isActive) {
        if (this.devId != devId || this.state < 1) {
            this.devId = devId;
            this.manager.registerGraphic(this);
        }
        this.state = state;
        this.cachedStrWidthChar = -1;
        this.cachedStrWidthStr = null;
        this.rj.sendMainCmd(new GDCmdItem.CInit(this.devId, width, height, canvasColor, isActive, this.slot));
    }

    public void close() {
        this.state = -1;
        this.manager.unregisterGraphic(this);
        this.rj.sendMainCmd(new GDCmdItem.CCloseDevice(this.devId, this.slot));
    }

    public void setMode(int mode) {
        if (this.state > 0) {
            this.rj.sendMainCmd(new GDCmdItem.CSetMode(this.devId, mode, this.slot));
        }
    }

    public void activate() {
        if (this.state > 0) {
            this.manager.activate(this);
        }
    }

    public void deactivate() {
        if (this.state > 0) {
            this.manager.deactivate(this);
        }
    }

    public boolean newPageConfirm() {
        return false;
    }

    public double @Nullable [] newPagePPI() {
        return (double[])this.rj.getClientProperty(this.slot, "display.ppi");
    }

    public double @Nullable [] newPageSize() {
        MainCmdItem answer = this.rj.sendMainCmd(new GDCmdItem.CGetSize(this.devId, this.slot));
        return answer instanceof GDCmdItem && answer.isOK() ? ((GDCmdItem)answer).getDoubleData() : null;
    }

    public void setColor(int color) {
        this.rj.sendMainCmd(new GDCmdItem.SetColor(this.devId, color, this.slot));
    }

    public void setFill(int color) {
        this.rj.sendMainCmd(new GDCmdItem.SetFill(this.devId, color, this.slot));
    }

    public void setLine(int lty, float lwd, byte cap, byte join, float joinMiterLimit) {
        this.rj.sendMainCmd(new GDCmdItem.SetLine(this.devId, lty, lwd, cap, join, joinMiterLimit, this.slot));
    }

    public void setClip(double x0, double x1, double y0, double y1) {
        this.rj.sendMainCmd(new GDCmdItem.SetClip(this.devId, x0, y0, x1, y1, this.slot));
    }

    public void drawLine(double x0, double y0, double x1, double y1) {
        this.rj.sendMainCmd(new GDCmdItem.DrawLine(this.devId, x0, y0, x1, y1, this.slot));
    }

    public void drawRect(double x0, double y0, double x1, double y1) {
        this.rj.sendMainCmd(new GDCmdItem.DrawRect(this.devId, x0, y0, x1, y1, this.slot));
    }

    public void drawPolyline(double[] x, double[] y) {
        this.rj.sendMainCmd(new GDCmdItem.DrawPolyline(this.devId, x, y, this.slot));
    }

    public void drawPolygon(double[] x, double[] y) {
        this.rj.sendMainCmd(new GDCmdItem.DrawPolygon(this.devId, x, y, this.slot));
    }

    public void drawPath(int[] n, double[] x, double[] y, int mode) {
        this.rj.sendMainCmd(new GDCmdItem.DrawPath(this.devId, n, x, y, mode, this.slot));
    }

    public void drawCircle(double x, double y, double r) {
        this.rj.sendMainCmd(new GDCmdItem.DrawCircle(this.devId, x, y, r, this.slot));
    }

    public void setFont(byte[] family, int face, float pointSize, float lineheight) {
        this.rj.sendMainCmd(new GDCmdItem.SetFont(this.devId, family, face, pointSize, lineheight, this.slot));
        this.cachedStrWidthChar = -1;
        this.cachedStrWidthStr = null;
    }

    public void setFont(String family, int face, float pointSize, float lineheight) {
        this.setFont(family.getBytes(StandardCharsets.UTF_8), face, pointSize, lineheight);
    }

    public double @Nullable [] getStrWidth(byte[] str) {
        int cp0 = Utf8Strings.getCodepoint((byte[])str, (int)0);
        if (cp0 != -1 && str.length == Utf8Strings.getCodepointLength((int)cp0)) {
            if (cp0 == this.cachedStrWidthChar) {
                return this.cachedStrWidthCharResult;
            }
            MainCmdItem answer = this.rj.sendMainCmd(new GDCmdItem.CGetStrWidth(this.devId, str, this.slot));
            this.cachedStrWidthCharResult = answer instanceof GDCmdItem && answer.isOK() ? ((GDCmdItem)answer).getDoubleData() : null;
            this.cachedStrWidthChar = cp0;
            return this.cachedStrWidthCharResult;
        }
        if (Arrays.equals(str, this.cachedStrWidthStr)) {
            return this.cachedStrWidthStrResult;
        }
        MainCmdItem answer = this.rj.sendMainCmd(new GDCmdItem.CGetStrWidth(this.devId, str, this.slot));
        this.cachedStrWidthStrResult = answer instanceof GDCmdItem && answer.isOK() ? ((GDCmdItem)answer).getDoubleData() : null;
        this.cachedStrWidthStr = str;
        return this.cachedStrWidthStrResult;
    }

    public double @Nullable [] getStrWidth(String str) {
        return this.getStrWidth(str.getBytes(StandardCharsets.UTF_8));
    }

    public double @Nullable [] getMetricInfo(int ch) {
        MainCmdItem answer = this.rj.sendMainCmd(new GDCmdItem.CGetFontMetric(this.devId, ch, this.slot));
        return answer instanceof GDCmdItem && answer.isOK() ? ((GDCmdItem)answer).getDoubleData() : null;
    }

    public void drawText(byte[] str, double x, double y, double rDeg, double hAdj) {
        this.rj.sendMainCmd(new GDCmdItem.DrawText(this.devId, str, x, y, rDeg, hAdj, this.slot));
    }

    public void drawText(String str, double x, double y, double rDeg, double hAdj) {
        this.rj.sendMainCmd(new GDCmdItem.DrawText(this.devId, str, x, y, rDeg, hAdj, this.slot));
    }

    public void drawRaster(byte[] imgData, boolean imgAlpha, int imgW, int imgH, double x, double y, double w, double h, double rDeg, boolean interpolate) {
        this.rj.sendMainCmd(new GDCmdItem.DrawRaster(this.devId, imgData, imgAlpha, imgW, imgH, x, y, w, h, rDeg, interpolate, this.slot));
    }

    public byte @Nullable [] capture(int[] dim) {
        MainCmdItem answer = this.rj.sendMainCmd(new GDCmdItem.Capture(this.devId, dim[0], dim[1], this.slot));
        return answer instanceof GDCmdItem && answer.isOK() ? ((GDCmdItem)answer).getByteData() : null;
    }

    public double @Nullable [] execLocator() {
        MainCmdItem answer = this.rj.sendMainCmd(new GDCmdItem.Locator(this.devId, this.slot));
        return answer instanceof GDCmdItem && answer.isOK() ? ((GDCmdItem)answer).getDoubleData() : null;
    }
}

