/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Collection;
import java.util.List;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD})
public final class ArrayUtils {
    public static final int[] EMPTY_INT = new int[0];
    public static final long[] EMPTY_LONG = new long[0];
    public static final Object[] EMPTY_OBJ = new Object[0];

    public static <E> boolean containsEqual(E[] array, int startIdx, int endIdx, E e) {
        if (e == null) {
            int idx = 0;
            while (idx < endIdx) {
                if (array[idx] == null) {
                    return true;
                }
                ++idx;
            }
            return false;
        }
        int idx = 0;
        while (idx < endIdx) {
            if (e.equals(array[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public static <E> boolean containsIdentical(E[] array, int startIdx, int endIdx, E e) {
        int idx = 0;
        while (idx < endIdx) {
            if (e == array[idx]) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public static void copyTo(Collection<?> src, Object[] dest, int destPos) {
        if (src instanceof AbstractImList) {
            ((AbstractImList)((Object)src)).copyTo(dest, destPos);
        } else if (destPos == 0) {
            src.toArray(dest);
        } else {
            Object[] a = src.toArray();
            System.arraycopy(a, 0, dest, destPos, a.length);
        }
    }

    public static <E> E[] copyAddElement(List<? extends E> l, int n, int index, E e) {
        Object[] a = new Object[n + 1];
        if (l instanceof AbstractImList) {
            if (index == 0) {
                ((AbstractImList)((Object)l)).copyTo(a, 1);
            } else if (index == n) {
                ((AbstractImList)((Object)l)).copyTo(a, 0);
            } else {
                ((AbstractImList)((Object)l)).copyTo(0, a, 0, index);
                ((AbstractImList)((Object)l)).copyTo(index, a, index + 1, n - index);
            }
        } else if (index == 0) {
            Object[] srcArray = l.toArray();
            System.arraycopy(srcArray, 0, a, 1, n);
        } else if (index == n) {
            l.toArray(a);
        } else {
            Object[] srcArray = l.toArray();
            System.arraycopy(srcArray, 0, a, 0, index);
            System.arraycopy(srcArray, index, a, index + 1, n - index);
        }
        a[index] = e;
        return a;
    }

    public static <E> E[] copyAddElement(Collection<? extends E> l, int n, E e) {
        Object[] a = new Object[n + 1];
        if (l instanceof AbstractImList) {
            ((AbstractImList)((Object)l)).copyTo(a, 0);
        } else {
            l.toArray(a);
        }
        a[n] = e;
        return a;
    }

    public static <E> E[] copyRemoveElement(List<? extends E> l, int n, int index) {
        Object[] a = new Object[n];
        if (l instanceof AbstractImList) {
            if (index > 0) {
                ((AbstractImList)((Object)l)).copyTo(0, a, 0, index);
            }
            if (index < n) {
                ((AbstractImList)((Object)l)).copyTo(index + 1, a, index, n - index);
            }
        } else {
            Object[] src = l.toArray();
            if (index > 0) {
                System.arraycopy(src, 0, a, 0, index);
            }
            if (index < n) {
                System.arraycopy(src, index + 1, a, index, n - index);
            }
        }
        return a;
    }

    public static int[] repeat(IntList l, int times) {
        int[] srcArray = l.toArray();
        int[] a = new int[srcArray.length * times];
        int i = 0;
        while (i < times) {
            System.arraycopy(srcArray, 0, a, i * srcArray.length, srcArray.length);
            ++i;
        }
        return a;
    }

    public static long[] repeat(LongList l, int times) {
        long[] srcArray = l.toArray();
        long[] a = new long[srcArray.length * times];
        int i = 0;
        while (i < times) {
            System.arraycopy(srcArray, 0, a, i * srcArray.length, srcArray.length);
            ++i;
        }
        return a;
    }

    public static String toString(int[] array, int start, int size) {
        if (size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(4 + size * 4);
        sb.append('[');
        sb.append(array[start++]);
        while (start < size) {
            sb.append(", ");
            sb.append(array[start++]);
        }
        sb.append(']');
        return sb.toString();
    }

    private ArrayUtils() {
    }
}

