/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.RjsStatus;

@NonNullByDefault
public abstract class MainCmdItem
implements RJIOExternalizable {
    public static final byte T_NONE = 0;
    public static final byte T_CONSOLE_READ_ITEM = 1;
    public static final byte T_CONSOLE_WRITE_ITEM = 2;
    public static final byte T_MESSAGE_ITEM = 4;
    public static final byte T_EXT_CLIENT_ITEM = 5;
    public static final byte T_GRAPH_ITEM = 7;
    public static final byte T_S2C_C2S = 9;
    public static final byte T_MAIN_CTRL_ITEM = 16;
    public static final byte T_DATA_ITEM = 17;
    public static final byte T_GRAPHICS_OP_ITEM = 18;
    public static final byte T_DBG_ITEM = 20;
    public static final byte T_SRV_ITEM = 32;
    protected static final int OM_STATUS = 0xF00000;
    protected static final int OS_STATUS = 20;
    protected static final int OM_WITH = 0xF000000;
    public static final int OV_ANSWER = 0x40000000;
    protected static final int OM_ANSWER = 0x40000000;
    public static final int OV_WAITFORCLIENT = Integer.MIN_VALUE;
    protected static final int OM_WAITFORCLIENT = Integer.MIN_VALUE;
    protected static final int OC_WAITFORCLIENT = Integer.MAX_VALUE;
    public static final int OM_CUSTOM = 65535;
    protected static final int OM_CLEARFORANSWER = -267386881;
    protected int options;
    public @Nullable MainCmdItem next;
    public int requestId;
    public byte slot;

    public abstract byte getCmdType();

    public abstract byte getOp();

    public final boolean waitForClient() {
        return (this.options & Integer.MIN_VALUE) != 0;
    }

    public final boolean isAnswer() {
        return (this.options & 0x40000000) != 0;
    }

    public final int getCmdOption() {
        return this.options & 0xFFFF;
    }

    public abstract void setAnswer(RjsStatus var1);

    public abstract boolean isOK();

    public abstract @Nullable RjsStatus getStatus();

    public abstract @Nullable String getDataText();

    public byte @Nullable [] getDataTextUtf8() {
        String text = this.getDataText();
        return text != null ? text.getBytes(StandardCharsets.UTF_8) : null;
    }

    public abstract void writeExternal(RJIO var1) throws IOException;

    public abstract boolean testEquals(MainCmdItem var1);
}

