/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslAstVisitor;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.Asts;

@NonNullByDefault
public class PropertiesContainer
extends DslAstNode {
    ImIdentityList<DslAstNode> properties = ImCollections.emptyIdentityList();
    DslAstNode nodeChild;

    public PropertiesContainer(DslAstNode parent, int startOffset, int endOffset) {
        super(parent);
        this.doSetStartEndOffset(startOffset, endOffset);
    }

    protected void doSetNodeChild(DslAstNode node) {
        this.nodeChild = node;
    }

    @Override
    protected void finish(int endOffset) {
        super.finish(endOffset);
        this.doSetEndOffsetMin(this.nodeChild.getEndOffset());
    }

    @Override
    protected boolean hasErrorInChild() {
        for (DslAstNode property : this.properties) {
            if (!Asts.hasErrors((AstNode)property)) continue;
            return true;
        }
        return Asts.hasErrors((AstNode)this.nodeChild);
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.PROPERTIES_CONTAINER;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return this.properties.size() + 1;
    }

    public final ImIdentityList<DslAstNode> getProperties() {
        return this.properties;
    }

    public final DslAstNode getNode() {
        return this.nodeChild;
    }

    @Override
    public final DslAstNode getChild(int index) {
        if (index == this.properties.size()) {
            return this.nodeChild;
        }
        return (DslAstNode)((Object)this.properties.get(index));
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.nodeChild == child) {
            return this.properties.size();
        }
        return this.properties.indexOf((Object)child);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        for (DslAstNode property : this.properties) {
            visitor.visit((AstNode)property);
        }
        visitor.visit((AstNode)this.nodeChild);
    }

    @Override
    public final void acceptInDsl(DslAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInDslChildren(DslAstVisitor visitor) throws InvocationTargetException {
        for (DslAstNode property : this.properties) {
            property.acceptInDsl(visitor);
        }
        this.nodeChild.acceptInDsl(visitor);
    }
}

