/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.model;

import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.util.NameUtils;

@NonNullByDefault
public abstract class WikitextElementName
implements ElementName {
    public static final byte RESOURCE = 15;
    public static final byte TITLE = 17;
    public static final byte LINK_ANCHOR_LABEL = 65;
    public static final byte LINK_DEF_LABEL = 69;

    public static WikitextElementName create(int type, String name) {
        return new Default(type, name);
    }

    public abstract @Nullable WikitextElementName getNextSegment();

    public WikitextElementName getLastSegment() {
        WikitextElementName lastSegment;
        WikitextElementName nextSegment = this;
        do {
            lastSegment = nextSegment;
        } while ((nextSegment = nextSegment.getNextSegment()) != null);
        return lastSegment;
    }

    public int hashCode() {
        String name = this.getSegmentName();
        WikitextElementName next = this.getNextSegment();
        if (next != null) {
            return this.getType() * (name != null ? name.hashCode() : 1) * (((Object)next).hashCode() + 7);
        }
        return this.getType() * (name != null ? name.hashCode() : 1);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WikitextElementName) {
            WikitextElementName other = (WikitextElementName)obj;
            return this.getType() == other.getType() && NameUtils.areEqual((String)this.getSegmentName(), (String)other.getSegmentName()) && Objects.equals(this.getNextSegment(), other.getNextSegment());
        }
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static class Default
    extends WikitextElementName {
        protected final int type;
        protected final String segment;

        private Default(int type, String name) {
            this.type = type;
            this.segment = name;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public @Nullable WikitextElementName getNextSegment() {
            return null;
        }

        public String getSegmentName() {
            return this.segment;
        }

        public String getDisplayName() {
            return this.segment;
        }
    }
}

