/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikidocParser;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstInfo;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguageManager1;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitEmbeddedModelReconciler;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProject;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProjects;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.ExtdocMarkupLanguage;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextCorePlugin;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.EmbeddingReconcileTask;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.LtxEmbeddedModelReconciler;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.SourceAnalyzer;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikitextModelManagerImpl;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.YamlEmbeddedModelReconciler;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CacheStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.build.ExtensibleReconciler;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;
import org.eclipse.statet.ltk.project.core.LtkProject;

@NonNullByDefault
public class WikidocReconciler
extends ExtensibleReconciler<WikitextProject, WikidocSourceUnitModelContainer<?>, WikidocSourceUnitEmbeddedModelReconciler<?>> {
    private static final ImIdentityList<String> DEFAULT_EMBEDDED_MODEL_IDS = ImCollections.newIdentityList((Object[])new String[]{"Yaml", "Ltx"});
    private static final boolean DEBUG_LOG_AST = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.docmlet.wikitext/debug/Reconciler/logAst"));
    private final Map<WikitextMarkupLanguage, WikitextMarkupLanguage> languages = new HashMap<WikitextMarkupLanguage, WikitextMarkupLanguage>();
    private final WikitextModelManagerImpl modelManager;
    protected boolean stop = false;
    private final WikitextMarkupLanguageManager1 markupLanguageManager;
    private final Object raLock = new Object();
    private final WikidocParser raParser = new WikidocParser((StringFactory)new CacheStringFactory(32));
    private final Object rmLock = new Object();
    private final SourceAnalyzer rmSourceAnalyzer = new SourceAnalyzer();
    private final Object riLock = new Object();

    public WikidocReconciler(WikitextModelManagerImpl manager) {
        this.modelManager = manager;
        this.markupLanguageManager = WikitextCore.getMarkupLanguageManager();
        this.raParser.setCollectHeadingText(true);
    }

    public void init(WikitextProject project, MultiStatus statusCollector) {
        super.init((LtkProject)project, statusCollector);
    }

    void stop() {
        this.stop = true;
    }

    protected @Nullable WikitextProject getProject(IProject wsProject) {
        return WikitextProjects.getWikitextProject(wsProject);
    }

    protected @Nullable WikidocSourceUnitEmbeddedModelReconciler<?> createEmbeddedModelReconciler(String modelTypeId) {
        if (modelTypeId == "Yaml") {
            return new YamlEmbeddedModelReconciler();
        }
        if (modelTypeId == "Ltx") {
            return new LtxEmbeddedModelReconciler();
        }
        return (WikidocSourceUnitEmbeddedModelReconciler)LtkModels.getModelAdapter((String)modelTypeId, WikidocSourceUnitEmbeddedModelReconciler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(WikidocSourceUnitModelContainer<?> adapter, int flags, IProgressMonitor monitor) {
        Data data;
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        ImIdentityList embeddedModelIds = DEFAULT_EMBEDDED_MODEL_IDS;
        String nowebTypeId = adapter.getNowebType();
        if (nowebTypeId != null) {
            embeddedModelIds = ImCollections.addElementIfAbsent(embeddedModelIds, (Object)nowebTypeId);
        }
        ImList extensions = this.initExtensions((ImCollection)embeddedModelIds, adapter, flags);
        if (nowebTypeId != null && !ExtensibleReconciler.ExtensionData.contains((ImList)extensions, (String)nowebTypeId)) {
            nowebTypeId = null;
        }
        if ((data = new Data(adapter, extensions, nowebTypeId, m)) == null || !data.isOK()) {
            adapter.clear();
            return;
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            this.updateAst(data, flags, m);
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        if ((flags & 0xF) < 2) {
            return;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            boolean updated = this.updateModel(data, flags, m);
            if (updated) {
                this.modelManager.getEventJob().addUpdate((LtkModelElement)data.sourceUnit, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            object = this.riLock;
            synchronized (object) {
                if (this.stop || m.isCanceled() || data.newModel != data.adapter.getCurrentModel()) {
                    return;
                }
                this.reportIssues(data, flags, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final @Nullable WikitextMarkupLanguage getMarkupLanguage(Data data, SubMonitor m) {
        WikitextSourceUnit su = (WikitextSourceUnit)data.adapter.getSourceUnit();
        WikitextMarkupLanguage markupLanguage = null;
        if (su.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
            AbstractDocument document = su.getDocument((IProgressMonitor)m);
            markupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)document, su.getDocumentContentInfo().getPartitioning());
        }
        if (markupLanguage == null && su instanceof WorkspaceSourceUnit) {
            markupLanguage = this.markupLanguageManager.getLanguage((IFile)su.getResource(), null, true);
        }
        if (markupLanguage == null) {
            return null;
        }
        Map<WikitextMarkupLanguage, WikitextMarkupLanguage> map = this.languages;
        synchronized (map) {
            WikitextMarkupLanguage internal = this.languages.get(markupLanguage);
            if (internal == null) {
                internal = markupLanguage.clone("Reconciler", markupLanguage.getMode());
                this.languages.put(internal, internal);
            }
            return internal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags, SubMonitor m) {
        WikitextMarkupLanguage markupLanguage = this.getMarkupLanguage(data, m);
        if (markupLanguage == null) {
            throw new UnsupportedOperationException("Markup language is missing.");
        }
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp(), this.createSourceConfig(markupLanguage, data.extensions));
        WikitextAstInfo ast = (WikitextAstInfo)data.adapter.getCurrentAst();
        if (ast != null && !stamp.equals(ast.getStamp())) {
            ast = null;
        }
        if (ast != null) {
            data.ast = ast;
        } else {
            this.raParser.setMarkupLanguage(markupLanguage);
            this.raParser.setCommentLevel(1);
            this.raParser.setCollectEmebeddedNodes(true);
            SourceComponent sourceNode = this.raParser.parse(data.content);
            List<Embedded> embeddedNodes = this.raParser.getEmbeddedNodes();
            ImIdentitySet embeddedTypeIds = this.collectEmbeddedTypeIds(embeddedNodes);
            for (ExtensibleReconciler.ExtensionData extensionData : data.extensions) {
                if (!embeddedTypeIds.contains((Object)extensionData.modelTypeId)) continue;
                ((WikidocSourceUnitEmbeddedModelReconciler)extensionData.reconciler).reconcileAst(data.content, embeddedNodes, markupLanguage, data.adapter, extensionData.config, flags);
            }
            ast = new WikitextAstInfo(1, (SourceModelStamp)stamp, sourceNode, markupLanguage, (ImIdentitySet<String>)embeddedTypeIds);
            if (DEBUG_LOG_AST) {
                this.logAst(ast, data.content);
            }
            WikidocSourceUnitModelContainer<?> wikidocSourceUnitModelContainer = data.adapter;
            synchronized (wikidocSourceUnitModelContainer) {
                data.adapter.setAst(ast);
            }
            data.ast = ast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, SubMonitor m) {
        WikidocSourceUnitModelInfo model = (WikidocSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (model != null && !data.getAst().getStamp().equals(model.getStamp())) {
            model = null;
        }
        if (model != null) {
            data.newModel = model;
            return false;
        }
        model = this.rmSourceAnalyzer.createModel((WikitextSourceUnit)data.adapter.getSourceUnit(), data.content.getString(), data.getAst());
        boolean isOK = model != null;
        ImIdentitySet embeddedTypes = data.getAst().getEmbeddedTypes();
        List<EmbeddingReconcileTask> embeddedItems = this.rmSourceAnalyzer.getEmbeddedItems();
        for (ExtensibleReconciler.ExtensionData extensionData : data.extensions) {
            if (!embeddedTypes.contains((Object)extensionData.modelTypeId) && data.nowebTypeId != extensionData.modelTypeId) continue;
            ((WikidocSourceUnitEmbeddedModelReconciler)extensionData.reconciler).reconcileModel(model, data.content, embeddedItems, data.adapter, extensionData.config, flags, m);
        }
        if (isOK) {
            WikidocSourceUnitModelContainer<?> wikidocSourceUnitModelContainer = data.adapter;
            synchronized (wikidocSourceUnitModelContainer) {
                data.oldModel = (WikidocSourceUnitModelInfo)data.adapter.getCurrentModel();
                data.adapter.setModel(model);
            }
            data.newModel = model;
            return true;
        }
        return false;
    }

    protected void reportIssues(Data data, int flags, SubMonitor m) {
        block8: {
            try {
                SourceUnitIssueSupport issueSupport = data.adapter.getIssueSupport();
                if (issueSupport == null) {
                    return;
                }
                IssueRequestor issueRequestor = issueSupport.createIssueRequestor((SourceUnit)data.sourceUnit);
                if (issueRequestor == null) break block8;
                try {
                    if (data.getAst().getMarkupLanguage() instanceof ExtdocMarkupLanguage) {
                        ((ExtdocMarkupLanguage)data.getAst().getMarkupLanguage()).getProblemReporter().run(data.sourceUnit, data.getModel(), data.content, issueRequestor, flags);
                    }
                    ImIdentitySet embeddedTypes = data.getAst().getEmbeddedTypes();
                    for (ExtensibleReconciler.ExtensionData extensionData : data.extensions) {
                        if (!embeddedTypes.contains((Object)extensionData.modelTypeId)) continue;
                        ((WikidocSourceUnitEmbeddedModelReconciler)extensionData.reconciler).reportIssues(data.getModel(), data.content, issueRequestor, data.adapter, extensionData.config, flags);
                    }
                }
                finally {
                    issueRequestor.finish();
                }
            }
            catch (Exception e) {
                this.handleStatus((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", 0, String.format("An error occurred when reporting issues for source unit %1$s.", data.sourceUnit), (Throwable)e));
            }
        }
    }

    protected void handleStatus(IStatus status) {
        MultiStatus collector = this.getStatusCollector();
        if (collector != null) {
            collector.add(status);
        } else {
            WikitextCorePlugin.log(status);
        }
    }

    protected static final class Data {
        public final WikidocSourceUnitModelContainer<?> adapter;
        public final ImList<ExtensibleReconciler.ExtensionData<WikitextProject, ?, WikidocSourceUnitEmbeddedModelReconciler<?>>> extensions;
        public final @Nullable String nowebTypeId;
        public final WikitextSourceUnit sourceUnit;
        public final WikitextCoreAccess coreAccess;
        public final SourceContent content;
        @Nullable WikitextAstInfo ast;
        @Nullable WikidocSourceUnitModelInfo oldModel;
        @Nullable WikidocSourceUnitModelInfo newModel;

        public Data(WikidocSourceUnitModelContainer<?> adapter, ImList<ExtensibleReconciler.ExtensionData<WikitextProject, ?, WikidocSourceUnitEmbeddedModelReconciler<?>>> extensions, @Nullable String nowebTypeId, SubMonitor monitor) {
            this.adapter = adapter;
            this.extensions = extensions;
            this.nowebTypeId = nowebTypeId;
            this.sourceUnit = (WikitextSourceUnit)adapter.getSourceUnit();
            this.content = adapter.getParseContent((IProgressMonitor)monitor);
            this.coreAccess = WikitextCore.getContextAccess((IAdaptable)adapter.getSourceUnit());
        }

        boolean isOK() {
            return this.content != null;
        }

        public WikitextAstInfo getAst() {
            return this.ast;
        }

        public WikidocSourceUnitModelInfo getModel() {
            return this.newModel;
        }
    }
}

