/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.config;

import org.eclipse.statet.ecommons.waltable.core.style.BasicStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.edit.editor.AbstractEditErrorHandler;
import org.eclipse.statet.ecommons.waltable.edit.editor.ControlDecorationProvider;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.editor.IEditErrorHandler;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;

public class RenderErrorHandling
extends AbstractEditErrorHandler {
    protected Style defaultErrorStyle = new BasicStyle();
    protected Color originalFgColor;
    protected Color originalBgColor;
    protected Font originalFont;
    protected Style errorStyle;
    protected final ControlDecorationProvider decorationProvider;
    private boolean errorStylingActive;

    public RenderErrorHandling() {
        this((ControlDecorationProvider)null);
    }

    public RenderErrorHandling(ControlDecorationProvider decorationProvider) {
        this(null, decorationProvider);
    }

    public RenderErrorHandling(IEditErrorHandler underlyingErrorHandler, ControlDecorationProvider decorationProvider) {
        super(underlyingErrorHandler);
        this.defaultErrorStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, GUIHelper.COLOR_RED);
        this.errorStylingActive = false;
        this.decorationProvider = decorationProvider;
        this.errorStyle = this.defaultErrorStyle;
    }

    @Override
    public void removeError(ICellEditor cellEditor) {
        super.removeError(cellEditor);
        if (this.errorStylingActive) {
            Control editorControl = cellEditor.getEditorControl();
            editorControl.setBackground(this.originalBgColor);
            editorControl.setForeground(this.originalFgColor);
            editorControl.setFont(this.originalFont);
            this.originalBgColor = null;
            this.originalFgColor = null;
            this.originalFont = null;
            if (this.decorationProvider != null) {
                this.decorationProvider.hideDecoration();
            }
            this.errorStylingActive = false;
        }
    }

    @Override
    public void displayError(ICellEditor cellEditor, Exception e) {
        super.displayError(cellEditor, e);
        if (!this.errorStylingActive) {
            Control editorControl = cellEditor.getEditorControl();
            this.originalBgColor = editorControl.getBackground();
            this.originalFgColor = editorControl.getForeground();
            this.originalFont = editorControl.getFont();
            editorControl.setBackground(this.errorStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR));
            editorControl.setForeground(this.errorStyle.getAttributeValue(CellStyling.FOREGROUND_COLOR));
            editorControl.setFont(this.errorStyle.getAttributeValue(CellStyling.FONT));
            if (this.decorationProvider != null) {
                this.decorationProvider.showDecoration();
            }
            this.errorStylingActive = true;
        }
    }

    public void setErrorStyle(Style errorStyle) {
        this.errorStyle = errorStyle != null ? errorStyle : this.defaultErrorStyle;
    }
}

