/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class BasicSelectionModel
implements SelectionModel {
    private final Layer selectionLayer;
    private boolean multipleSelectionAllowed;
    private final List<LRectangle> selections;
    private final ReadWriteLock selectionsLock;

    private static final @Nullable LRectangle getLeftSelection(LRectangle intersection, LRectangle selection) {
        if (intersection.x > selection.x) {
            return new LRectangle(selection.x, selection.y, intersection.x - selection.x, selection.height);
        }
        return null;
    }

    private static final @Nullable LRectangle getRightSelection(LRectangle intersection, LRectangle selection) {
        long newX = intersection.x + intersection.width;
        if (newX < selection.x + selection.width) {
            return new LRectangle(newX, selection.y, selection.x + selection.width - newX, selection.height);
        }
        return null;
    }

    private static final @Nullable LRectangle getTopSelection(LRectangle intersection, LRectangle selection) {
        if (intersection.y > selection.y) {
            return new LRectangle(selection.x, selection.y, selection.width, intersection.y - selection.y);
        }
        return null;
    }

    private static final @Nullable LRectangle getBottomSelection(LRectangle intersection, LRectangle selection) {
        long newY = intersection.y + intersection.height;
        if (newY < selection.y + selection.height) {
            return new LRectangle(selection.x, newY, selection.width, selection.y + selection.height - newY);
        }
        return null;
    }

    public BasicSelectionModel(Layer selectionLayer) {
        this(selectionLayer, true);
    }

    public BasicSelectionModel(Layer selectionLayer, boolean multipleSelectionAllowed) {
        this.selectionLayer = (Layer)ObjectUtils.nonNullAssert((Object)selectionLayer);
        this.multipleSelectionAllowed = multipleSelectionAllowed;
        this.selections = new LinkedList<LRectangle>();
        this.selectionsLock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean isMultipleSelectionAllowed() {
        return this.multipleSelectionAllowed;
    }

    public void setMultipleSelectionAllowed(boolean multipleSelectionAllowed) {
        this.multipleSelectionAllowed = multipleSelectionAllowed;
    }

    @Override
    public void addSelection(long columnPosition, long rowPosition) {
        this.addSelectionIntoList(new LRectangle(columnPosition, rowPosition, 1L, 1L));
    }

    @Override
    public void addSelection(LRectangle positions) {
        if (positions != null) {
            this.addSelectionIntoList(positions);
        }
    }

    private void addSelectionIntoList(LRectangle selection) {
        this.selectionsLock.writeLock().lock();
        try {
            if (this.multipleSelectionAllowed) {
                ArrayList<LRectangle> itemsToRemove = null;
                for (LRectangle r : this.selections) {
                    if (!selection.intersects(r)) continue;
                    if (r.equals(selection)) break;
                    LRectangle intersection = selection.intersection(r);
                    if (intersection.equals(r)) {
                        if (itemsToRemove == null) {
                            itemsToRemove = new ArrayList<LRectangle>();
                        }
                        itemsToRemove.add(r);
                        continue;
                    }
                    if (intersection.equals(selection)) break;
                }
                if (itemsToRemove != null) {
                    this.selections.removeAll(itemsToRemove);
                }
            } else {
                this.selections.clear();
                selection.height = 1L;
                selection.width = 1L;
            }
            this.selections.add(selection);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection() {
        this.selectionsLock.writeLock().lock();
        try {
            this.selections.clear();
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(long columnPosition, long rowPosition) {
        this.clearSelection(new LRectangle(columnPosition, rowPosition, 1L, 1L));
    }

    @Override
    public void clearSelection(LRectangle positions) {
        LinkedList<LRectangle> removedItems = new LinkedList<LRectangle>();
        LinkedList<LRectangle> addedItems = new LinkedList<LRectangle>();
        this.selectionsLock.readLock().lock();
        try {
            for (LRectangle r : this.selections) {
                LRectangle bottomSelection;
                LRectangle leftSelection;
                LRectangle rightSelection;
                if (!r.intersects(positions)) continue;
                LRectangle intersection = positions.intersection(r);
                removedItems.add(r);
                LRectangle topSelection = BasicSelectionModel.getTopSelection(intersection, r);
                if (topSelection != null) {
                    addedItems.add(topSelection);
                }
                if ((rightSelection = BasicSelectionModel.getRightSelection(intersection, r)) != null) {
                    addedItems.add(rightSelection);
                }
                if ((leftSelection = BasicSelectionModel.getLeftSelection(intersection, r)) != null) {
                    addedItems.add(leftSelection);
                }
                if ((bottomSelection = BasicSelectionModel.getBottomSelection(intersection, r)) == null) continue;
                addedItems.add(bottomSelection);
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        if (removedItems.size() > 0) {
            this.selectionsLock.writeLock().lock();
            try {
                this.selections.removeAll(removedItems);
            }
            finally {
                this.selectionsLock.writeLock().unlock();
            }
            removedItems.clear();
        }
        if (addedItems.size() > 0) {
            this.selectionsLock.writeLock().lock();
            try {
                this.selections.addAll(addedItems);
            }
            finally {
                this.selectionsLock.writeLock().unlock();
            }
            addedItems.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = this.selections.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public List<LRectangle> getSelections() {
        return this.selections;
    }

    @Override
    public boolean isCellPositionSelected(LayerCell cell) {
        this.selectionsLock.readLock().lock();
        try {
            LRectangle cellRectangle = new LRectangle(cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnSpan(), cell.getRowSpan());
            for (LRectangle selectionRectangle : this.selections) {
                if (!selectionRectangle.intersects(cellRectangle)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public LRangeList getSelectedColumnPositions() {
        this.selectionsLock.readLock().lock();
        try {
            LRangeList selected = new LRangeList();
            long columnCount = this.selectionLayer.getColumnCount();
            for (LRectangle r : this.selections) {
                if (r.x >= columnCount) continue;
                selected.add(new LRange(r.x, Math.min(r.x + r.width, columnCount)));
            }
            LRangeList lRangeList = selected;
            return lRangeList;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isColumnPositionSelected(long columnPosition) {
        this.selectionsLock.readLock().lock();
        try {
            long columnCount = this.selectionLayer.getColumnCount();
            if (columnPosition >= 0L && columnPosition < columnCount) {
                for (LRectangle r : this.selections) {
                    if (columnPosition < r.x || columnPosition >= r.x + r.width) continue;
                    return true;
                }
            }
            return false;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public LRangeList getFullySelectedColumnPositions() {
        this.selectionsLock.readLock().lock();
        try {
            LRangeList selected = new LRangeList();
            long rowCount = this.selectionLayer.getRowCount();
            if (rowCount > 0L) {
                LRangeList selectedColumns = this.getSelectedColumnPositions();
                for (LRange lRange : selectedColumns) {
                    long position = lRange.start;
                    while (position < lRange.end) {
                        if (this.isColumnPositionFullySelected(position, rowCount)) {
                            selected.values().add(position);
                        }
                        ++position;
                    }
                }
            }
            LRangeList lRangeList = selected;
            return lRangeList;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isColumnPositionFullySelected(long columnPosition) {
        this.selectionsLock.readLock().lock();
        try {
            long rowCount = this.selectionLayer.getRowCount();
            boolean bl = rowCount > 0L && this.isColumnPositionFullySelected(columnPosition, rowCount);
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private boolean isColumnPositionFullySelected(long columnPosition, long rowCount) {
        LRangeList selectedRowsInColumn = new LRangeList();
        for (LRectangle r : this.selections) {
            if (columnPosition < r.x || columnPosition >= r.x + r.width) continue;
            selectedRowsInColumn.add(new LRange(r.y, r.y + r.height));
        }
        LRange lRange = selectedRowsInColumn.values().getRangeOf(0L);
        return lRange != null && lRange.end >= rowCount;
    }

    @Override
    public long getSelectedRowCount() {
        return this.getSelectedRowPositions().values().size();
    }

    @Override
    public LRangeList getSelectedRowPositions() {
        this.selectionsLock.readLock().lock();
        try {
            LRangeList selected = new LRangeList();
            long rowCount = this.selectionLayer.getRowCount();
            for (LRectangle r : this.selections) {
                if (r.y >= rowCount) continue;
                selected.add(new LRange(r.y, Math.min(r.y + r.height, rowCount)));
            }
            LRangeList lRangeList = selected;
            return lRangeList;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isRowPositionSelected(long rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            long rowCount = this.selectionLayer.getRowCount();
            if (rowPosition >= 0L && rowPosition < rowCount) {
                for (LRectangle r : this.selections) {
                    if (rowPosition < r.y || rowPosition >= r.y + r.height) continue;
                    return true;
                }
            }
            return false;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public LRangeList getFullySelectedRowPositions() {
        this.selectionsLock.readLock().lock();
        try {
            LRangeList selected = new LRangeList();
            long columnCount = this.selectionLayer.getColumnCount();
            if (columnCount > 0L) {
                LRangeList selectedRows = this.getSelectedRowPositions();
                for (LRange lRange : selectedRows) {
                    long position = lRange.start;
                    while (position < lRange.end) {
                        if (this.isRowPositionFullySelected(position, columnCount)) {
                            selected.values().add(position);
                        }
                        ++position;
                    }
                }
            }
            LRangeList lRangeList = selected;
            return lRangeList;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isRowPositionFullySelected(long rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            long columnCount = this.selectionLayer.getColumnCount();
            boolean bl = columnCount > 0L && this.isRowPositionFullySelected(rowPosition, columnCount);
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private boolean isRowPositionFullySelected(long rowPosition, long columnCount) {
        LRangeList selectedColumnsInRow = new LRangeList();
        for (LRectangle r : this.selections) {
            if (rowPosition < r.y || rowPosition >= r.y + r.height) continue;
            selectedColumnsInRow.add(new LRange(r.x, r.x + r.width));
        }
        LRange lRange = selectedColumnsInRow.values().getRangeOf(0L);
        return lRange != null && lRange.end >= columnCount;
    }

    public String toString() {
        this.selectionsLock.readLock().lock();
        try {
            String string = this.selections.toString();
            return string;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }
}

