/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.ui.matcher.MouseEventMatcher;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeDetectUtil;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeEnum;
import org.eclipse.swt.events.MouseEvent;

public class ColumnHeaderClickEventMatcher
extends MouseEventMatcher {
    public ColumnHeaderClickEventMatcher(int stateMask, int button) {
        super(stateMask, "COLUMN_HEADER", button);
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return super.matches(natTable, event, regionLabels) && this.isNearTheHeaderEdge(natTable, event) && this.isNotFilterRegion(regionLabels);
    }

    private boolean isNearTheHeaderEdge(Layer natLayer, MouseEvent event) {
        CellEdgeEnum cellEdge = CellEdgeDetectUtil.getHorizontalCellEdge(natLayer, new LPoint(event.x, event.y), 4L);
        return cellEdge == CellEdgeEnum.NONE;
    }

    private boolean isNotFilterRegion(LabelStack regionLabels) {
        if (regionLabels != null) {
            return !regionLabels.getLabels().contains("FILTER_ROW");
        }
        return true;
    }
}

