/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort.core;

import org.eclipse.statet.ecommons.waltable.core.Persistable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.sort.SortStatePersistor;
import org.eclipse.statet.ecommons.waltable.sort.config.DefaultSortConfiguration;
import org.eclipse.statet.ecommons.waltable.sort.core.SortDirection;
import org.eclipse.statet.ecommons.waltable.sort.core.SortModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SortHeaderLayer<T>
extends ForwardLayer<ForwardLayerDim<? extends SortHeaderLayer<T>>>
implements Persistable {
    private final SortModel sortModel;

    public SortHeaderLayer(Layer underlyingLayer, SortModel sortModel) {
        this(underlyingLayer, sortModel, true);
    }

    public SortHeaderLayer(Layer underlyingLayer, SortModel sortModel, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.sortModel = sortModel;
        this.init();
        this.registerPersistable(new SortStatePersistor(sortModel));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSortConfiguration());
        }
    }

    @Override
    protected ForwardLayerDim<? extends SortHeaderLayer<T>> createDim(Orientation orientation) {
        return new ForwardLayerDim<SortHeaderLayer>(this, this.getUnderlyingLayer().getDim(orientation));
    }

    public SortModel getSortModel() {
        return this.sortModel;
    }

    @Override
    protected LayerCell createCell(LayerCellDim hDim, LayerCellDim vDim, LayerCell underlyingCell) {
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell){

            @Override
            public LabelStack getLabels() {
                LabelStack configLabels = super.getLabels();
                long id = this.getDim(Orientation.HORIZONTAL).getId();
                if (SortHeaderLayer.this.sortModel.isSorted(id)) {
                    String sortConfig = "SORT_SEQ_" + SortHeaderLayer.this.sortModel.getSortOrder(id);
                    configLabels.addLabelOnTop(sortConfig);
                    SortDirection sortDirection = SortHeaderLayer.this.sortModel.getSortDirection(id);
                    switch (sortDirection) {
                        case ASC: {
                            configLabels.addLabelOnTop("SORT_UP");
                            break;
                        }
                        case DESC: {
                            configLabels.addLabelOnTop("SORT_DOWN");
                            break;
                        }
                    }
                }
                return configLabels;
            }
        };
    }
}

