/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.util;

import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeEnum;

public class CellEdgeDetectUtil {
    public static long getPositionToResize(Layer layer, LPoint clickPoint, Orientation orientation) {
        LayerCell cell = layer.getCellByPosition(layer.getDim(Orientation.HORIZONTAL).getPositionByPixel(clickPoint.x), layer.getDim(Orientation.VERTICAL).getPositionByPixel(clickPoint.y));
        if (cell != null) {
            long position = cell.getDim(orientation).getPosition();
            CellEdgeEnum edge = orientation == Orientation.HORIZONTAL ? CellEdgeDetectUtil.getHorizontalCellEdge(cell.getBounds(), clickPoint, 4L) : CellEdgeDetectUtil.getVerticalCellEdge(cell.getBounds(), clickPoint, 4L);
            switch (edge) {
                case LEFT: 
                case TOP: {
                    if (position == 1L) break;
                    return position - 1L;
                }
                case RIGHT: 
                case BOTTOM: {
                    return position;
                }
            }
        }
        return Long.MIN_VALUE;
    }

    public static CellEdgeEnum getHorizontalCellEdge(Layer layer, LPoint clickPt) {
        return CellEdgeDetectUtil.getHorizontalCellEdge(layer, clickPt, -1L);
    }

    public static CellEdgeEnum getHorizontalCellEdge(Layer layer, LPoint clickPt, long handleWidth) {
        LayerCell cell = layer.getCellByPosition(layer.getColumnPositionByX(clickPt.x), layer.getRowPositionByY(clickPt.y));
        if (cell != null) {
            return CellEdgeDetectUtil.getHorizontalCellEdge(cell.getBounds(), clickPt, handleWidth);
        }
        return CellEdgeEnum.NONE;
    }

    private static CellEdgeEnum getHorizontalCellEdge(LRectangle cellBounds, LPoint clickPt, long distanceFromEdge) {
        if (distanceFromEdge < 0L) {
            distanceFromEdge = cellBounds.width / 2L;
        }
        LRectangle left = new LRectangle(cellBounds.x, cellBounds.y, distanceFromEdge, cellBounds.height);
        LRectangle right = new LRectangle(cellBounds.x + cellBounds.width - distanceFromEdge, cellBounds.y, distanceFromEdge, cellBounds.height);
        if (left.contains(clickPt)) {
            return CellEdgeEnum.LEFT;
        }
        if (right.contains(clickPt)) {
            return CellEdgeEnum.RIGHT;
        }
        return CellEdgeEnum.NONE;
    }

    public static CellEdgeEnum getVerticalCellEdge(Layer layer, LPoint clickPt) {
        return CellEdgeDetectUtil.getVerticalCellEdge(layer, clickPt, -1L);
    }

    public static CellEdgeEnum getVerticalCellEdge(Layer layer, LPoint clickPt, long handleHeight) {
        LayerCell cell = layer.getCellByPosition(layer.getColumnPositionByX(clickPt.x), layer.getRowPositionByY(clickPt.y));
        if (cell != null) {
            return CellEdgeDetectUtil.getVerticalCellEdge(cell.getBounds(), clickPt, handleHeight);
        }
        return CellEdgeEnum.NONE;
    }

    private static CellEdgeEnum getVerticalCellEdge(LRectangle cellBounds, LPoint clickPt, long distanceFromEdge) {
        if (distanceFromEdge < 0L) {
            distanceFromEdge = cellBounds.height / 2L;
        }
        LRectangle top = new LRectangle(cellBounds.x, cellBounds.y, cellBounds.width, distanceFromEdge);
        LRectangle bottom = new LRectangle(cellBounds.x, cellBounds.y + cellBounds.height - distanceFromEdge, cellBounds.width, distanceFromEdge);
        if (top.contains(clickPt)) {
            return CellEdgeEnum.TOP;
        }
        if (bottom.contains(clickPt)) {
            return CellEdgeEnum.BOTTOM;
        }
        return CellEdgeEnum.NONE;
    }
}

