/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.pool;

import java.time.Duration;
import java.time.Instant;
import org.eclipse.statet.internal.rj.servi.NodeHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.servi.pool.PoolNodeObject;
import org.eclipse.statet.rj.servi.pool.PoolNodeState;

@NonNullByDefault
public class PoolNodeItem {
    private final PoolNodeObject nodeObj;
    private Instant creationTime;
    private PoolNodeState state;
    private Instant stateTime;
    private long usageCount;
    private @Nullable Duration usageDuration;
    private @Nullable RMIAddress address;
    private @Nullable String clientLabel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolNodeItem(PoolNodeObject nodeObj, Instant stamp) {
        PoolNodeObject poolNodeObject = nodeObj;
        synchronized (poolNodeObject) {
            this.nodeObj = nodeObj;
            this.creationTime = nodeObj.getCreationTime();
            this.state = nodeObj.getState();
            this.stateTime = nodeObj.getStateTime();
            this.usageCount = nodeObj.getAllocationCount();
            this.usageDuration = nodeObj.getLastestAllocationDuration();
            NodeHandler nodeHandler = nodeObj.getNodeHandler();
            this.address = nodeHandler != null ? nodeHandler.getAddress() : null;
            this.clientLabel = nodeObj.getClientLabel();
        }
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public PoolNodeState getState() {
        return this.state;
    }

    public Instant getStateTime() {
        return this.stateTime;
    }

    public @Nullable String getCurrentClientLabel() {
        return this.clientLabel;
    }

    public long getUsageCount() {
        return this.usageCount;
    }

    public @Nullable Duration getUsageDuration() {
        return this.usageDuration;
    }

    public boolean isConsoleEnabled() {
        NodeHandler nodeHandler = this.nodeObj.getNodeHandler();
        return nodeHandler != null && nodeHandler.isConsoleEnabled();
    }

    public void enableConsole(String authConfig) throws RjException {
        NodeHandler nodeHandler = this.nodeObj.getNodeHandler();
        if (nodeHandler != null) {
            nodeHandler.enableConsole(authConfig);
        }
    }

    public void disableConsole() throws RjException {
        NodeHandler nodeHandler = this.nodeObj.getNodeHandler();
        if (nodeHandler != null) {
            nodeHandler.disableConsole();
        }
    }

    public @Nullable RMIAddress getAddress() {
        return this.address;
    }

    public void evict(@Nullable Duration timeout) {
        if (this.nodeObj != null) {
            this.nodeObj.evict(timeout);
        }
    }
}

