/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.runtime.eplatform;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.statet.jcommons.io.ArchiveUrl;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class EPlatformBundleResolver
implements BundleResolver {
    public EPlatformBundleResolver() {
        if (Platform.getBundle((String)"org.eclipse.statet.jcommons.util") == null) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean resolveBundle(BundleSpec bundleSpec, Set<BundleEntry> resolved, MultiStatus status) {
        Bundle pluginBundle = Platform.getBundle((String)bundleSpec.getId());
        if (pluginBundle != null) {
            boolean ok = this.addEntries(pluginBundle, resolved, status);
            @NonNull Bundle[] fragments = Platform.getFragments((Bundle)pluginBundle);
            if (fragments != null) {
                Bundle[] bundleArray = fragments;
                int n = fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle fragmentBundle = bundleArray[n2];
                    this.addEntries(fragmentBundle, resolved, status);
                    ++n2;
                }
            }
            return ok;
        }
        return false;
    }

    private boolean addEntries(Bundle bundle, Set<BundleEntry> resolved, MultiStatus status) {
        Path path;
        boolean isJar;
        String libId;
        block4: {
            try {
                Path jClassPath;
                ArchiveUrl archiveUrl;
                libId = ObjectUtils.nonNullAssert(bundle.getSymbolicName());
                URI url = UriUtils.toUri(FileLocator.resolve((URL)ObjectUtils.nonNullAssert(bundle.getEntry("/"))));
                isJar = UriUtils.isJarUrl(url);
                if (isJar && (archiveUrl = UriUtils.getArchiveUrl(url)) != null && archiveUrl.getInnerEntryPathString().isEmpty()) {
                    url = archiveUrl.getInnerArchiveUrl();
                }
                path = Path.of(url);
                if (!Platform.inDevelopmentMode() || isJar || !Files.isDirectory(jClassPath = path.resolve("target/classes"), new LinkOption[0])) break block4;
                resolved.add(new OsgiDirBundleEntry(libId, path, jClassPath, bundle));
                return true;
            }
            catch (Exception e) {
                status.add(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to check location for plug-in: '%1$s'.", bundle.getSymbolicName()), e));
                return false;
            }
        }
        resolved.add(isJar ? new OsgiJarBundleEntry(libId, path, bundle) : new OsgiDirBundleEntry(libId, path, path, bundle));
        return true;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("BundleResolver", this.getClass());
        return sb.toString();
    }

    private static class OsgiDirBundleEntry
    extends BundleEntry.Dir {
        private final Bundle osgiBundle;

        public OsgiDirBundleEntry(String bundleId, Path path, Path jClassPath, Bundle osgiBundle) {
            super(bundleId, path, jClassPath);
            this.osgiBundle = osgiBundle;
        }

        @Override
        public @Nullable String getResourceUrlString(String resource) {
            URL intern = this.osgiBundle.getEntry(resource);
            if (intern != null) {
                try {
                    URI url = UriUtils.toUri(FileLocator.resolve((URL)intern));
                    return url.toString();
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            return super.getResourceUrlString(resource);
        }
    }

    private static class OsgiJarBundleEntry
    extends BundleEntry.Jar {
        private final Bundle osgiBundle;

        public OsgiJarBundleEntry(String bundleId, Path path, Bundle osgiBundle) {
            super(bundleId, path);
            this.osgiBundle = osgiBundle;
        }

        @Override
        public @Nullable String getResourceUrlString(String resource) {
            URL intern = this.osgiBundle.getEntry(resource);
            if (intern != null) {
                try {
                    URI url = UriUtils.toUri(FileLocator.resolve((URL)intern));
                    return url.toString();
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            return super.getResourceUrlString(resource);
        }
    }
}

