/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers;

import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.swt.ScheduledDisplayRunnable;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public abstract class BasicCustomViewer<TSelection extends ISelection>
extends Viewer
implements IPostSelectionProvider {
    private final Display display;
    private TSelection selection;
    private final CopyOnWriteIdentityListSet<ISelectionChangedListener> selectionListeners = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<ISelectionChangedListener> postSelectionListeners = new CopyOnWriteIdentityListSet();
    private long updateSelectionDefaultAsyncDelayNanos;
    private SelectionRunnable updateSelectionRunnable = (SelectionRunnable)ObjectUtils.nonNullLateInit();
    private PostSelectionRunnable postSelectionRunnable = (PostSelectionRunnable)ObjectUtils.nonNullLateInit();

    public BasicCustomViewer(Display display, TSelection initalSelection) {
        this.display = display;
        this.selection = initalSelection;
    }

    protected boolean isDisposed() {
        return this.getControl().isDisposed();
    }

    public TSelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        long t = System.nanoTime();
        this.selection = selection;
        this.handleSelectionChanged(t, UpdateType.DIRECT);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            SafeRunnable.run(() -> listener.selectionChanged(event));
        }
    }

    protected void firePostSelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.postSelectionListeners) {
            SafeRunnable.run(() -> listener.selectionChanged(event));
        }
    }

    protected void initSelectionController(TSelection initialSelection, long updateDefaultAsyncDelayNanos) {
        this.selection = initialSelection;
        this.updateSelectionDefaultAsyncDelayNanos = updateDefaultAsyncDelayNanos;
        this.updateSelectionRunnable = new SelectionRunnable();
        this.postSelectionRunnable = new PostSelectionRunnable();
    }

    protected void refreshSelection(int flags, UpdateType type, boolean async) {
        long stamp = System.nanoTime();
        this.updateSelectionRunnable.schedule(flags, stamp, type, async);
    }

    protected @Nullable TSelection fetchSelectionFromWidget(int flags, TSelection prevSelection) {
        return null;
    }

    private void updateSelection(UpdateType type, long stamp, int flags) {
        TSelection newSelection = this.fetchSelectionFromWidget(flags, this.selection);
        if (newSelection == null || newSelection.equals(this.selection)) {
            return;
        }
        this.selection = newSelection;
        this.handleSelectionChanged(stamp, type);
    }

    private void handleSelectionChanged(long stamp, UpdateType type) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
        this.fireSelectionChanged(event);
        this.postSelectionRunnable.schedule(event, stamp, type);
    }

    private class PostSelectionRunnable
    extends ScheduledDisplayRunnable {
        private @Nullable SelectionChangedEvent event;

        public PostSelectionRunnable() {
            super(BasicCustomViewer.this.display);
        }

        public void schedule(SelectionChangedEvent event, long stamp, UpdateType updateType) {
            this.event = event;
            if (updateType == UpdateType.DEFAULT_DELAYED_POST) {
                this.scheduleFor(stamp + (long)OpenStrategy.getPostSelectionDelay(), 1);
            } else {
                this.runNow();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.event = null;
        }

        @Override
        protected void execute() {
            SelectionChangedEvent event = this.event;
            this.event = null;
            if (event == null || BasicCustomViewer.this.isDisposed()) {
                return;
            }
            BasicCustomViewer.this.firePostSelectionChanged(event);
        }
    }

    private class SelectionRunnable
    extends ScheduledDisplayRunnable {
        private final Object updateExchLock;
        private int updateFlags;
        private @Nullable UpdateType updateRequest;
        private long updateRequestStamp;

        public SelectionRunnable() {
            super(BasicCustomViewer.this.display);
            this.updateExchLock = new Object();
            this.updateRequest = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(int flags, long stamp, UpdateType updateType, boolean async) {
            long scheduleTime;
            Object object = this.updateExchLock;
            synchronized (object) {
                this.updateFlags |= flags;
                if (updateType == UpdateType.DIRECT) {
                    this.updateRequest = UpdateType.DIRECT;
                    this.updateRequestStamp = stamp;
                    scheduleTime = stamp;
                } else if (this.updateRequest != UpdateType.DEFAULT) {
                    this.updateRequest = updateType;
                    this.updateRequestStamp = stamp;
                    scheduleTime = async ? stamp + BasicCustomViewer.this.updateSelectionDefaultAsyncDelayNanos : stamp;
                } else {
                    return;
                }
            }
            if (async) {
                this.scheduleFor(scheduleTime);
            } else {
                this.runNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            long stamp;
            UpdateType type;
            int flags;
            Object object = this.updateExchLock;
            synchronized (object) {
                flags = this.updateFlags;
                this.updateFlags = 0;
                type = this.updateRequest;
                this.updateRequest = null;
                stamp = this.updateRequestStamp;
            }
            if (type == null || BasicCustomViewer.this.isDisposed()) {
                return;
            }
            BasicCustomViewer.this.updateSelection(type, stamp, flags);
        }
    }

    public static enum UpdateType {
        DIRECT,
        DEFAULT,
        DEFAULT_DELAYED_POST;

    }
}

