/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SourceEditorTextHandler;

@NonNullByDefault
public class DeleteNextWordHandler
extends SourceEditorTextHandler {
    public DeleteNextWordHandler(SourceEditor editor) {
        super(editor);
    }

    @Override
    protected int getTextActionId() {
        return 262271;
    }

    @Override
    protected void exec(SourceEditorTextHandler.ExecData data) throws BadLocationException {
        if (data.getWidget().getBlockSelection()) {
            int newDocOffset;
            BlockTextSelection blockSelection = (BlockTextSelection)data.getViewer().getSelection();
            if (blockSelection.getEndColumn() > blockSelection.getStartColumn() || data.getCaretDocOffset() == data.getCaretDocLineEndOffset()) {
                data.getWidget().invokeAction(127);
                return;
            }
            if (blockSelection.getStartColumn() > data.getCaretDocLineInformation().getLength()) {
                if (blockSelection.getStartLine() == blockSelection.getEndLine()) {
                    data.getWidget().invokeAction(0x1000008);
                    return;
                }
                newDocOffset = data.getCaretDocLineEndOffset();
            } else {
                newDocOffset = this.findNextWordOffset(data, data.getCaretDocOffset(), true);
            }
            int newWidgetOffset = data.toWidgetOffset(newDocOffset);
            if (newWidgetOffset >= 0) {
                this.expandBlockSelection(data, newWidgetOffset);
                data.getWidget().invokeAction(127);
            }
        } else if (data.getWidget().getSelectionCount() > 0) {
            data.getWidget().invokeAction(127);
        } else {
            int newDocOffset = this.findNextWordOffset(data, data.getCaretDocOffset(), false);
            Region docRegion = new Region(data.getCaretDocOffset(), newDocOffset - data.getCaretDocOffset());
            this.delete(data, (IRegion)docRegion);
        }
    }
}

