/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pager;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.text.core.util.ImmutableDocument;
import org.eclipse.statet.internal.r.ui.pager.TextFileParser;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.input.SourceFragment;
import org.eclipse.statet.ltk.ui.input.SourceFragmentEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

@NonNullByDefault
public class TextFileDocumentProvider
extends AbstractDocumentProvider {
    final TextFileParser parser = new TextFileParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        AbstractDocument document = null;
        if (document == null) {
            document = this.createDocument(element);
        }
        if (document != null) {
            ImList<ITypedRegion> formatRegions;
            String orgText = document.get();
            TextFileParser textFileParser = this.parser;
            synchronized (textFileParser) {
                this.parser.parse(orgText);
                if (this.parser.getCleanText() != orgText) {
                    document = new ImmutableDocument(this.parser.getCleanText(), document.getModificationStamp());
                }
                formatRegions = this.parser.getFormatRegions();
            }
            this.setupDocument(document);
            TextFileElementInfo info = new TextFileElementInfo((IDocument)document, formatRegions, this.createAnnotationModel(element));
            return info;
        }
        return null;
    }

    protected @Nullable AbstractDocument createDocument(Object element) throws CoreException {
        if (element instanceof SourceFragmentEditorInput) {
            SourceFragment fragment = ((SourceFragmentEditorInput)element).getSourceFragment();
            return fragment.getDocument();
        }
        return null;
    }

    protected void setupDocument(AbstractDocument document) {
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new AnnotationModel();
    }

    protected @Nullable IRunnableContext getOperationRunner(@Nullable IProgressMonitor monitor) {
        return null;
    }

    protected void doSaveDocument(@Nullable IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    public ImList<ITypedRegion> getTextFormatRegions(@Nullable Object element) {
        AbstractDocumentProvider.ElementInfo elementInfo;
        if (element instanceof SourceFragmentEditorInput && (elementInfo = this.getElementInfo(element)) instanceof TextFileElementInfo) {
            return ((TextFileElementInfo)elementInfo).formatRegions;
        }
        return ImCollections.emptyList();
    }

    public class TextFileElementInfo
    extends AbstractDocumentProvider.ElementInfo {
        private final ImList<ITypedRegion> formatRegions;

        public TextFileElementInfo(IDocument document, ImList<ITypedRegion> formatRegions, IAnnotationModel model) {
            super((AbstractDocumentProvider)TextFileDocumentProvider.this, document, model);
            this.formatRegions = formatRegions;
        }
    }
}

