/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.statet.internal.r.ui.editors.AbstractRCompletionElementComputer;
import org.eclipse.statet.internal.r.ui.editors.RElementCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RHelpTopicCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RSimpleCompletionProposal;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RSearchPattern;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RFrameSearchPath;
import org.eclipse.statet.r.core.model.rlang.RLangElement;
import org.eclipse.statet.r.core.model.rlang.RSrcStrFrame;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.r.ui.sourceediting.WorkbenchRFrameSearchPath;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpTopicEntry;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public class RElementCompletionComputer
extends AbstractRCompletionElementComputer
implements ContentAssistComputer {
    private final WorkbenchRFrameSearchPath searchPath = new WorkbenchRFrameSearchPath();

    protected RElementCompletionComputer(int rSearchMode) {
        super(rSearchMode);
    }

    public RElementCompletionComputer() {
        super(0);
    }

    @Override
    protected void clear() {
        super.clear();
        this.searchPath.clear();
    }

    protected final boolean isSymbolCandidate(String name) {
        int i = 0;
        while (i < name.length()) {
            if (RTokens.isRobustSeparator((int)name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void computeCompletionProposals(int mode, IProgressMonitor monitor) {
        if (this.getRContext().getModelInfo() == null) {
            return;
        }
        RAstNode node = this.getRContext().getInvocationRAstNode();
        RElementName prefixName = this.getRContext().getIdentifierElementName();
        if (prefixName == null) {
            return;
        }
        if (prefixName.getNextSegment() == null) {
            String help = this.checkHelp();
            if (help != null) {
                this.addHelpTopicProposals(help, node, prefixName, 40);
                if (prefixName.getScope() == null) {
                    this.addPkgNameProposals(prefixName, -40);
                }
                return;
            }
            this.doComputeArgumentProposals(prefixName, monitor);
            if (this.in == 1) {
                this.doComputeMainProposals(node, prefixName, monitor);
            }
            if (this.rSearchMode == 0 && this.in == 1) {
                this.addKeywordCompletions(prefixName);
            }
            if (this.rSearchMode == 0) {
                AbstractRCompletionElementComputer.ContextSubject subject;
                if (this.isPackageName(prefixName)) {
                    if (this.pkgNamePrio > 0) {
                        this.addPkgNameProposals(prefixName, this.pkgNamePrio);
                    } else if (!prefixName.getSegmentName().isEmpty()) {
                        this.addPkgNameProposals(prefixName, -40);
                    }
                }
                if ((subject = this.getSubject(262144)) != null && subject.prio > 0) {
                    this.addHelpTopicProposals(null, node, prefixName, subject.prio);
                }
                if ((subject = this.getSubject(0x100000)) != null && subject.prio > 0) {
                    this.addRoleCodeCompletions(subject.prio);
                }
            }
        } else {
            this.doComputeSubProposals(node, prefixName, monitor);
        }
    }

    private @Nullable String checkHelp() {
        try {
            if (this.getRContext().getIdentifierOffset() > 0 && this.getRContext().getDocument().getChar(this.getRContext().getIdentifierOffset() - 1) == '?') {
                String prefix = this.getRContext().computeIdentifierPrefix(this.getRContext().getIdentifierOffset() - 1);
                if (prefix != null && !prefix.isEmpty()) {
                    if (prefix.equals("class") || prefix.equals("methods")) {
                        return prefix;
                    }
                    return null;
                }
                return "";
            }
            return null;
        }
        catch (BadLocationException | BadPartitioningException e) {
            this.log((Exception)e);
            return null;
        }
    }

    protected void doComputeArgumentProposals(RElementName prefixName, IProgressMonitor monitor) {
        try {
            RAssistInvocationContext.FCallInfo fCallInfo = this.getRContext().getFCallInfo();
            if (fCallInfo != null) {
                this.addFCallArgCompletions(fCallInfo, prefixName, null);
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    protected void doComputeMainProposals(RAstNode node, RElementName prefixName, IProgressMonitor monitor) {
        try {
            this.searchPath.init(this.getRContext(), node, this.getRSearchMode(), prefixName.getScope());
            this.addMainElementCompletions(this.searchPath, prefixName);
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doComputeSubProposals(RAstNode node, RElementName prefixName, IProgressMonitor monitor) {
        RElementName prefixSegment;
        RFrame envir;
        this.searchPath.init(this.getRContext(), node, this.getRSearchMode(), prefixName.getScope());
        int count = 0;
        RElementName prefixSegment2 = prefixName;
        while (true) {
            ++count;
            if (prefixSegment2.getNextSegment() == null) break;
            prefixSegment2 = prefixSegment2.getNextSegment();
        }
        String namePrefix = prefixSegment2.getSegmentName() != null ? prefixSegment2.getSegmentName() : "";
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(this.getRContext(), this.getRContext().getIdentifierLastSegmentOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), namePrefix), this.labelProvider);
        HashSet<String> mainNames = new HashSet<String>();
        ArrayList<String> methodNames = new ArrayList<String>();
        RFrameSearchPath.Iterator iter = this.searchPath.iterator();
        while (iter.hasNext()) {
            envir = iter.next();
            parameters.baseRelevance = iter.getRelevance();
            List elements = envir.getModelChildren(null);
            block2: for (RLangElement rootElement : elements) {
                boolean childMode;
                List<? extends RLangElement> children;
                boolean isRich;
                RElementName elementName = rootElement.getElementName();
                int c1type = rootElement.getElementType() & 0xF00;
                boolean bl = isRich = c1type == 1280;
                if (!isRich && c1type != 1536) continue;
                RLangElement element = rootElement;
                prefixSegment = prefixName;
                RElementName elementSegment = elementName;
                int i = 0;
                while (i < count - 1) {
                    block16: {
                        if (elementSegment == null) {
                            children = this.getChildren(element);
                            for (RLangElement rLangElement : children) {
                                elementSegment = rLangElement.getElementName();
                                if (!this.isCompletable(elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment.getSegmentName())) continue;
                                element = rLangElement;
                                prefixSegment = prefixSegment.getNextSegment();
                                elementSegment = elementSegment.getNextSegment();
                                break block16;
                            }
                            continue block2;
                        }
                        if (!this.isCompletable(elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment.getSegmentName())) continue block2;
                        prefixSegment = prefixSegment.getNextSegment();
                        elementSegment = elementSegment.getNextSegment();
                    }
                    ++i;
                }
                if (elementSegment == null) {
                    childMode = true;
                    children = this.getChildren(element);
                } else {
                    childMode = false;
                    children = Collections.singletonList(element);
                }
                for (RLangElement rLangElement : children) {
                    if (childMode) {
                        elementSegment = rLangElement.getElementName();
                    }
                    String candidate = elementSegment.getSegmentName();
                    if (!this.isCompletable(elementSegment) || !parameters.matchesNamePattern(candidate)) continue;
                    if (parameters.baseRelevance > 0 && !isRich && mainNames.contains(candidate)) continue block2;
                    parameters.replacementName = elementSegment;
                    parameters.element = rLangElement;
                    RElementCompletionProposal proposal = new RElementCompletionProposal(parameters);
                    if (elementSegment.getNextSegment() == null) {
                        if (isRich) {
                            methodNames.add(candidate);
                        } else {
                            mainNames.add(candidate);
                        }
                    }
                    this.proposals.add((AssistProposal)proposal);
                }
            }
        }
        mainNames.addAll(methodNames);
        iter = this.searchPath.iterator();
        while (iter.hasNext()) {
            void sframe;
            envir = iter.next();
            parameters.baseRelevance = 0;
            RFrame rFrame = envir;
            if (!(rFrame instanceof RSrcStrFrame)) continue;
            RSrcStrFrame cfr_ignored_0 = (RSrcStrFrame)rFrame;
            RSrcStrFrame cfr_ignored_1 = (RSrcStrFrame)rFrame;
            ImList allAccess = sframe.getAllAccessOf(prefixName.getSegmentName(), true);
            if (allAccess == null) continue;
            Iterator iterator = allAccess.iterator();
            block7: while (iterator.hasNext()) {
                String candidate;
                RElementAccess elementAccess;
                RElementAccess elementSegment = elementAccess = (RElementAccess)iterator.next();
                prefixSegment = prefixName;
                int i = 0;
                while (i < count - 1) {
                    if (!this.isCompletable((RElementName)elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment.getSegmentName())) continue block7;
                    prefixSegment = prefixSegment.getNextSegment();
                    elementSegment = elementSegment.getNextSegment();
                    ++i;
                }
                if (elementSegment == null || elementSegment.isSlave() || (candidate = elementSegment.getSegmentName()) == null || !this.isCompletable((RElementName)elementSegment) || candidate.equals(namePrefix) || mainNames.contains(candidate) || !parameters.matchesNamePattern(candidate)) continue;
                RSimpleCompletionProposal proposal = new RSimpleCompletionProposal(parameters, candidate);
                mainNames.add(candidate);
                this.proposals.add((AssistProposal)proposal);
            }
        }
    }

    @Override
    protected void computeContextProposals(IProgressMonitor monitor) {
        if (this.getRContext().getModelInfo() == null) {
            return;
        }
        RAssistInvocationContext.FCallInfo fCallInfo = this.getRContext().getFCallInfo();
        if (fCallInfo != null) {
            this.addFCallArgContexts(fCallInfo, null);
        }
    }

    protected final void addPkgNameProposals(RElementName prefixName, int prio) {
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (prefixName.getScope() != null || !this.isSymbolCandidate(prefixSegmentName)) {
            return;
        }
        this.addPkgNameCompletions(prefixSegmentName, prio);
    }

    protected final void addHelpTopicProposals(@Nullable String topicType, RAstNode node, RElementName prefixName, int prio) {
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (topicType == null && (prefixName.getScope() != null || prefixSegmentName.isEmpty())) {
            return;
        }
        REnv rEnv = this.getRContext().getRCoreAccess().getREnv();
        if (rEnv == null) {
            return;
        }
        RHelpManager rHelpManager = RCore.getRHelpManager();
        REnvHelp help = rHelpManager.getHelp(rEnv);
        if (help != null) {
            try {
                SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getRContext(), this.getRContext().getInvocationContentType() != "R.Default" ? this.getRContext().getIdentifierLastSegmentOffset() + 1 : this.getRContext().getIdentifierLastSegmentOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefixSegmentName), prio);
                HashMap<String, RHelpTopicCompletionProposal> map = new HashMap<String, RHelpTopicCompletionProposal>();
                this.searchPath.init(this.getRContext(), node, this.getRSearchMode(), prefixName.getScope());
                HashSet<String> pkgNames = new HashSet<String>();
                Iterator iterator = this.searchPath.iterator();
                while (iterator.hasNext()) {
                    RPkgHelp pkgHelp;
                    String pkgName;
                    RFrame frame = (RFrame)iterator.next();
                    if (frame.getFrameType() != 2 || (pkgName = frame.getElementName().getSegmentName()) == null || !pkgNames.add(pkgName) || (pkgHelp = help.getPkgHelp(pkgName)) == null) continue;
                    for (RHelpTopicEntry topicEntry : pkgHelp.getTopics()) {
                        String topic = topicEntry.getTopic();
                        if (!parameters.matchesNamePattern(topic)) continue;
                        RHelpTopicCompletionProposal proposal = (RHelpTopicCompletionProposal)((Object)map.get(topic));
                        if (proposal == null) {
                            proposal = new RHelpTopicCompletionProposal((SourceProposal.ProposalParameters<RAssistInvocationContext>)parameters, topic, topicEntry.getPage());
                            map.put(topic, proposal);
                            this.proposals.add((AssistProposal)proposal);
                            continue;
                        }
                        proposal.addPage(topicEntry.getPage());
                    }
                }
            }
            finally {
                help.unlock();
            }
        }
    }

    public static class CompleteRuntime
    extends RElementCompletionComputer {
        public CompleteRuntime() {
            super(3);
        }
    }
}

