/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.statet.ecommons.emf.core.IContext;
import org.eclipse.statet.ecommons.models.core.util.ElementSourceProvider;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

class RExprViewerDropAdapter
extends ViewerDropAdapter {
    private final List<RExprTypeUIAdapter> uiAdapters;
    private final IContext context;

    protected RExprViewerDropAdapter(Viewer viewer, List<RExprTypeUIAdapter> uiAdapters, IContext context) {
        super(viewer);
        this.uiAdapters = uiAdapters;
        this.context = context;
        this.setFeedbackEnabled(true);
    }

    protected int determineLocation(DropTargetEvent event) {
        int location = super.determineLocation(event);
        if (location == 3) {
            return 2;
        }
        return location;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        DropTargetEvent event = this.getCurrentEvent();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            return this.isValidInput(LocalSelectionTransfer.getTransfer().getSelection(), event);
        }
        return false;
    }

    public boolean performDrop(Object data) {
        DropTargetEvent event = this.getCurrentEvent();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            return this.setInput(LocalSelectionTransfer.getTransfer().getSelection(), event);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isValidInput(Object input, DropTargetEvent event) {
        Object object = input;
        if (object instanceof IStructuredSelection) {
            void selection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)object;
            if (selection.getFirstElement() instanceof RTypedExpr) {
                if ((event.operations & 3) == 0) {
                    return false;
                }
                List list = selection.toList();
                for (Object element : list) {
                    if (element instanceof RTypedExpr && this.isTypeSupported(((RTypedExpr)element).getTypeKey())) continue;
                    return false;
                }
                int operation = event.detail;
                if (operation != 1) {
                    operation = 1;
                    if (selection instanceof ElementSourceProvider) {
                        int move;
                        Object source = ((ElementSourceProvider)selection).getElementSource();
                        int n = move = source instanceof IContext ? this.isMoveValid((IContext)source, input) : 0;
                        if (move > 0 && (event.detail == 2 || move > 10 && event.detail == 16)) {
                            operation = 2;
                        }
                    }
                }
                this.overrideOperation(operation);
                return true;
            }
        }
        if ((event.operations & 1) == 0) {
            return false;
        }
        for (RExprTypeUIAdapter uiAdapters : this.uiAdapters) {
            if (uiAdapters.isValidInput(input, this.context) <= 0) continue;
            this.overrideOperation(1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setInput(Object input, DropTargetEvent event) {
        List<String> exprs;
        Object object = input;
        if (object instanceof IStructuredSelection) {
            void selection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)object;
            if (selection.getFirstElement() instanceof RTypedExpr) {
                if (event.detail == 2) {
                    this.moveExprs((IContext)((ElementSourceProvider)input).getElementSource(), selection.toList(), this.getInsertIndex(), event.time);
                } else {
                    List list = selection.toList();
                    ArrayList<RTypedExpr> values = new ArrayList<RTypedExpr>(list.size());
                    for (RTypedExpr expr : list) {
                        values.add(new RTypedExpr(expr.getTypeKey(), expr.getExpr()));
                    }
                    this.insertExprs(values, this.getInsertIndex(), event.time);
                }
                return true;
            }
        }
        int selectedPriority = 0;
        RExprTypeUIAdapter selectedAdapter = null;
        for (RExprTypeUIAdapter uiAdapters : this.uiAdapters) {
            int priority = uiAdapters.isValidInput(input, this.context);
            if (priority <= 0 || !(uiAdapters.getType().getTypeKey() == this.getCurrentTypeKey() ? priority >= selectedPriority : priority > selectedPriority)) continue;
            selectedPriority = priority;
            selectedAdapter = uiAdapters;
        }
        if (selectedAdapter != null && (exprs = selectedAdapter.getInputExprs(input, this.context)) != null && !exprs.isEmpty()) {
            String typeKey = selectedAdapter.getType().getTypeKey();
            ArrayList<RTypedExpr> values = new ArrayList<RTypedExpr>(exprs.size());
            for (String expr : exprs) {
                values.add(new RTypedExpr(typeKey, expr));
            }
            this.insertExprs(values, this.getInsertIndex(), event.time);
            return true;
        }
        return false;
    }

    protected int getInsertIndex() {
        int index = this.getIndex(this.getCurrentTarget());
        if (index >= 0) {
            int location = this.getCurrentLocation();
            switch (location) {
                case 1: {
                    break;
                }
                case 2: {
                    ++index;
                    break;
                }
                default: {
                    index = -1;
                }
            }
        }
        return index;
    }

    protected Object getSource() {
        return this.context;
    }

    protected int getIndex(Object element) {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected int isMoveValid(IContext source, Object input) {
        if (!this.canMove(source, input)) {
            return 0;
        }
        if (this.getSource() == source) {
            return 20;
        }
        Object object = input;
        if (object instanceof IStructuredSelection) {
            void selection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)object;
            if (selection.getFirstElement() instanceof RTypedExpr) {
                int selectedPriority = Integer.MAX_VALUE;
                ArrayList<String> checked = new ArrayList<String>(this.uiAdapters.size());
                for (Object element : selection.toList()) {
                    RTypedExpr expr = (RTypedExpr)element;
                    if (checked.contains(expr.getTypeKey())) continue;
                    checked.add(expr.getTypeKey());
                    RExprTypeUIAdapter uiAdapter = this.getUIAdapter(expr.getTypeKey());
                    int priority = uiAdapter.isMoveValid(input, source, this.context);
                    if (priority <= 0) {
                        return 0;
                    }
                    if (priority >= priority) continue;
                    selectedPriority = priority;
                }
                return selectedPriority;
            }
        }
        return 0;
    }

    protected boolean canMove(IContext source, Object input) {
        return false;
    }

    protected boolean isTypeSupported(String typeKey) {
        return this.getUIAdapter(typeKey) != null;
    }

    protected RExprTypeUIAdapter getUIAdapter(String typeKey) {
        for (RExprTypeUIAdapter uiAdapter : this.uiAdapters) {
            if (uiAdapter.getType().getTypeKey() != typeKey) continue;
            return uiAdapter;
        }
        return null;
    }

    protected String getCurrentTypeKey() {
        return null;
    }

    protected void insertExprs(List<RTypedExpr> exprs, int index, int time) {
    }

    protected void moveExprs(IContext source, List<RTypedExpr> exprs, int index, int time) {
    }
}

