/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.IOException;
import org.eclipse.statet.internal.r.core.builder.ExportedRElement;
import org.eclipse.statet.jcommons.io.DataStream;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.RFunctionSpec;
import org.eclipse.statet.r.core.model.rlang.RLangSrcElement;
import org.eclipse.statet.r.core.model.rlang.RMethodSrcElement;

@NonNullByDefault
public class ExportedRMethod
extends ExportedRElement
implements RMethodSrcElement<RLangSrcElement<?>> {
    private final @Nullable RFunctionSpec fSpec;
    static final byte SER_ELEMENT_TYPE = 2;
    static final byte SER_WITH_SPEC = 64;

    public ExportedRMethod(RLangSrcElement<?> parent, RMethodSrcElement<?> sourceElement) {
        super(parent, sourceElement);
        this.fSpec = sourceElement.getFunctionSpec();
    }

    ExportedRMethod(RLangSrcElement<?> parent, DataStream in, byte o) throws IOException {
        super(parent, in, o);
        this.fSpec = (o & 0x40) != 0 ? new RFunctionSpec(in, 1) : null;
    }

    @Override
    void writeTo(DataStream out, byte o) throws IOException {
        o = (byte)2;
        if (this.fSpec != null) {
            o = (byte)(o | 0x40);
        }
        super.writeTo(out, o);
        if (this.fSpec != null) {
            this.fSpec.writeTo(out, (byte)1);
        }
    }

    @Override
    public @Nullable RFunctionSpec getFunctionSpec() {
        return this.fSpec;
    }
}

