/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.server;

import jakarta.annotation.PreDestroy;
import org.eclipse.statet.internal.rhelp.server.RHelpServerInternals;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.runtime.AppEnvironment;
import org.eclipse.statet.jcommons.runtime.BasicAppEnvironment;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.Bundles;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.StatusLogger;
import org.eclipse.statet.jcommons.status.util.ACommonsLoggingStatusLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackageClasses={RHelpServerInternals.class})
@ServletComponentScan(basePackageClasses={RHelpServerInternals.class})
@NonNullByDefault
public class RHelpServerApplication
extends BasicAppEnvironment {
    public static final String BUNDLE_ID = "org.eclipse.statet.rhelp.server";
    @Autowired
    private ApplicationContext appContext;

    public static void main(@NonNull String[] args) {
        ImList argList;
        SpringApplication app = new SpringApplication(new Class[]{RHelpServerApplication.class});
        if (args != null && (argList = ImCollections.newList((Object[])args)).contains((Object)"-index-and-exit")) {
            app.setWebApplicationType(WebApplicationType.NONE);
            app.setAdditionalProfiles(new String[]{"index-and-exit"});
        }
        app.run(args);
    }

    public RHelpServerApplication() throws StatusException {
        super(BUNDLE_ID, (StatusLogger)new ACommonsLoggingStatusLogger(), Bundles.createResolver());
        CommonsRuntime.init((AppEnvironment)this);
        this.log((Status)new InfoStatus(BUNDLE_ID, "Application started."));
    }

    @PreDestroy
    protected void dispose() {
        this.onAppStopping();
        this.log((Status)new InfoStatus(BUNDLE_ID, "Application stopped."));
    }
}

