/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class TCFModelPresentation
implements IDebugModelPresentation {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    private static final String[] attr_names = new String[]{"lineNumber", "line", "org.eclipse.cdt.debug.core.address", "address", "org.eclipse.cdt.debug.core.function", "location", "org.eclipse.cdt.debug.core.expression", "expression", "org.eclipse.cdt.debug.core.condition", "condition", "org.eclipse.cdt.debug.core.eventbreakpoint_event_id", "event type", "org.eclipse.cdt.debug.core.eventbreakpoint_event_arg", "event args", "org.eclipse.tcf.debug.ContextNames", "scope (names)", "org.eclipse.tcf.debug.ContextIds", "scope (IDs)", "org.eclipse.tcf.debug.ExecPaths", "scope (modules)", "org.eclipse.tcf.debug.StopGroup", "stop group"};
    private final Collection<ILabelProviderListener> listeners = new HashSet<ILabelProviderListener>();
    private HashMap<String, Object> attrs = new HashMap();
    private static final TCFModelPresentation default_instance = new TCFModelPresentation();

    public static TCFModelPresentation getDefault() {
        return default_instance;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof IBreakpoint) {
            final IBreakpoint breakpoint = (IBreakpoint)element;
            descriptor = ImageCache.getImageDescriptor("icons/full/obj16/brkpd_obj");
            try {
                String cond;
                if (breakpoint.isEnabled()) {
                    descriptor = (ImageDescriptor)new TCFTask<ImageDescriptor>(){

                        public void run() {
                            boolean installed = false;
                            boolean warning = false;
                            boolean error = false;
                            boolean moved = false;
                            ImageDescriptor d = ImageCache.getImageDescriptor("icons/full/obj16/brkp_obj");
                            Map<TCFLaunch, Map<String, Object>> status = Activator.getAnnotationManager().getBreakpointStatus(breakpoint);
                            for (TCFLaunch launch : status.keySet()) {
                                Object planted;
                                Map<String, Object> map = status.get(launch);
                                if (map == null) continue;
                                if ((String)map.get("Error") != null) {
                                    error = true;
                                }
                                if ((planted = map.get("Instances")) == null) continue;
                                Collection list = (Collection)planted;
                                for (Map m : list) {
                                    if (m.get("ConditionError") != null) {
                                        error = true;
                                    }
                                    if (m.get("Error") == null) {
                                        TCFModel model;
                                        installed = true;
                                        if (moved) continue;
                                        TCFNodeExecContext ctx = null;
                                        String ctx_id = (String)m.get("LocationContext");
                                        BigInteger addr = JSON.toBigInteger((Number)((Number)m.get("Address")));
                                        int line = breakpoint.getMarker().getAttribute("lineNumber", 0);
                                        if (ctx_id != null && addr != null && line > 0 && (model = TCFModelManager.getModelManager().getModel(launch)) != null) {
                                            if (!model.createNode(ctx_id, (Runnable)((Object)this))) {
                                                return;
                                            }
                                            TCFDataCache<TCFNodeExecContext> mem = model.searchMemoryContext(model.getNode(ctx_id));
                                            if (mem != null) {
                                                if (!mem.validate((Runnable)((Object)this))) {
                                                    return;
                                                }
                                                ctx = (TCFNodeExecContext)mem.getData();
                                            }
                                        }
                                        if (ctx == null) continue;
                                        ILineNumbers.CodeArea area = null;
                                        TCFDataCache<TCFSourceRef> line_cache = ctx.getLineInfo(addr);
                                        if (line_cache != null) {
                                            if (!line_cache.validate((Runnable)((Object)this))) {
                                                return;
                                            }
                                            TCFSourceRef line_data = (TCFSourceRef)line_cache.getData();
                                            if (line_data != null && line_data.area != null) {
                                                area = line_data.area;
                                            }
                                        }
                                        if (area == null || area.start_line == line) continue;
                                        moved = true;
                                        continue;
                                    }
                                    warning = true;
                                }
                            }
                            if (moved) {
                                d = ImageCache.addOverlay(d, "icons/moved_ovr", 0, 0);
                            } else if (installed) {
                                d = ImageCache.addOverlay(d, "icons/ovr16/installed_ovr", 0, 8);
                            }
                            if (warning) {
                                d = ImageCache.addOverlay(d, "icons/ovr16/warning_ovr", 9, 8);
                            }
                            if (error) {
                                d = ImageCache.addOverlay(d, "icons/ovr16/error_ovr", 9, 8);
                            }
                            this.done(d);
                        }
                    }.getE();
                }
                if ((cond = breakpoint.getMarker().getAttribute("org.eclipse.cdt.debug.core.condition", null)) != null && cond.length() > 0) {
                    descriptor = ImageCache.addOverlay(descriptor, "icons/ovr16/conditional_ovr");
                }
            }
            catch (Throwable throwable) {}
        }
        if (descriptor != null) {
            return ImageCache.getImage(descriptor);
        }
        return null;
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof IBreakpoint) {
            final IBreakpoint breakpoint = (IBreakpoint)element;
            IMarker marker = breakpoint.getMarker();
            if (marker == null) {
                return null;
            }
            StringBuffer bf = new StringBuffer();
            try {
                Path path;
                Map m = marker.getAttributes();
                String file = marker.getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
                if (file != null && file.length() > 0 && (path = new Path(file)).isValidPath(file)) {
                    bf.append(this.isShowQualifiedNames() ? path.toOSString() : path.lastSegment());
                    bf.append(' ');
                }
                int i = 0;
                while (i < attr_names.length) {
                    String s;
                    Object obj = m.get(attr_names[i]);
                    if (obj != null && (s = obj.toString()).length() != 0) {
                        bf.append('[');
                        bf.append(attr_names[i + 1]);
                        bf.append(": ");
                        bf.append(s);
                        bf.append(']');
                    }
                    i += 2;
                }
                if (bf.length() == 0) {
                    String id = marker.getAttribute("org.eclipse.tcf.debug.ID", null);
                    if (id == null) {
                        id = Long.toString(marker.getId());
                    }
                    bf.append(id);
                }
            }
            catch (Throwable x) {
                return x.toString();
            }
            text = bf.toString();
            String status = (String)new TCFTask<String>(){

                public void run() {
                    this.done(Activator.getAnnotationManager().getBreakpointStatusText(breakpoint));
                }
            }.getE();
            if (status != null) {
                text = String.valueOf(text) + " (" + status + ")";
            }
        }
        return text;
    }

    protected boolean isShowQualifiedNames() {
        Boolean show_qualified = (Boolean)this.attrs.get(DISPLAY_FULL_PATHS);
        if (show_qualified == null) {
            return false;
        }
        return show_qualified;
    }

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            this.attrs.remove(attribute);
        } else {
            this.attrs.put(attribute, value);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public String getEditorId(IEditorInput input, Object element) {
        String id = null;
        if (input != null) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
            id = descriptor != null && !descriptor.isOpenExternal() ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
        }
        return id;
    }

    public IEditorInput getEditorInput(Object element) {
        Object fullPath;
        URI uri;
        if (element instanceof ILineBreakpoint) {
            element = ((ILineBreakpoint)element).getMarker();
        }
        if (element instanceof IMarker) {
            element = ((IMarker)element).getResource();
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IStorage && (uri = URIUtil.toURI((IPath)(fullPath = element instanceof LocalFileStorage ? new Path(((LocalFileStorage)element).getFile().getAbsolutePath()) : ((IStorage)element).getFullPath()))) != null) {
            try {
                return new FileStoreEditorInput(EFS.getStore((URI)uri));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return null;
    }
}

