/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters.PeerNodeViewerInput;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public class ViewerInputAdapterFactory
implements IAdapterFactory {
    private static final String VIEWER_INPUT_KEY = String.valueOf(UIPlugin.getUniqueIdentifier()) + ".peer.viewerInput";

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IPeerNode && (IViewerInput.class.equals((Object)adapterType) || IPropertyChangeProvider.class.equals((Object)adapterType))) {
            IPeerNode peerNode = (IPeerNode)adaptableObject;
            return this.getViewerInput(peerNode);
        }
        return null;
    }

    PeerNodeViewerInput getViewerInput(final IPeerNode peerNode) {
        if (peerNode != null) {
            if (Protocol.isDispatchThread()) {
                PeerNodeViewerInput model = (PeerNodeViewerInput)((Object)peerNode.getProperty(VIEWER_INPUT_KEY));
                if (model == null) {
                    model = new PeerNodeViewerInput(peerNode);
                    peerNode.setProperty(VIEWER_INPUT_KEY, (Object)model);
                }
                return model;
            }
            final AtomicReference reference = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    reference.set(ViewerInputAdapterFactory.this.getViewerInput(peerNode));
                }
            });
            return (PeerNodeViewerInput)((Object)reference.get());
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IViewerInput.class, IPropertyChangeProvider.class};
    }
}

