/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.files;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.AbstractRemoteFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;

public class TCFRemoteFile
extends AbstractRemoteFile {
    public TCFRemoteFile(FileServiceSubSystem ss, IRemoteFileContext ctx, IRemoteFile parent, IHostFile file) {
        super(ss, ctx, parent, file);
    }

    public IRemoteFile getParentRemoteFile() {
        if (this._parentFile == null) {
            if (this.isRoot()) {
                return null;
            }
            IRemoteFile parentFile = null;
            IRemoteFileSubSystem ss = this._context.getParentRemoteFileSubSystem();
            if (ss != null) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    parentFile = ss.getRemoteFileObject(this.getParentPath(), (IProgressMonitor)monitor);
                }
                catch (SystemMessageException e) {
                    SystemBasePlugin.logError((String)"TCFRemoteFile.getParentRemoteFile()", (Throwable)e);
                }
            }
            this._parentFile = parentFile;
        }
        return this._parentFile;
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public String getClassification() {
        String result = this.isFile() ? "file" : (this.isDirectory() ? "directory" : "unknown");
        return result;
    }
}

