/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.core.interfaces.IFilterable;
import org.eclipse.tcf.te.ui.trees.TreeViewerLabelProvider;
import org.eclipse.tcf.te.ui.utils.TreeViewerUtil;

public class TreeViewerDecoratingLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private TreeViewerLabelProvider fProvider;
    private ILabelDecorator fDecorator;
    private TreeViewer viewer;
    private ITreeContentProvider contentProvider;

    public TreeViewerDecoratingLabelProvider(TreeViewer viewer, TreeViewerLabelProvider provider, ILabelDecorator decorator) {
        super((ILabelProvider)provider, decorator);
        this.fProvider = provider;
        this.fDecorator = decorator;
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = this.fProvider.getColumnImage(element, columnIndex);
        if (columnIndex == 0) {
            if (this.fDecorator != null) {
                if (this.fDecorator instanceof LabelDecorator) {
                    LabelDecorator ld2 = (LabelDecorator)this.fDecorator;
                    Image decorated = ld2.decorateImage(image, element, this.getDecorationContext());
                    if (decorated != null) {
                        image = decorated;
                    }
                } else {
                    Image decorated = this.fDecorator.decorateImage(image, element);
                    if (decorated != null) {
                        image = decorated;
                    }
                }
            }
            IFilterable decorator = this.adaptFilterable(element);
            TreePath path = this.getTreePath(element);
            if (image != null && decorator != null && path != null && TreeViewerUtil.isFiltering(this.viewer, path)) {
                image = TreeViewerUtil.getDecoratedImage(image, this.viewer, path);
            }
        }
        return image;
    }

    private TreePath getTreePath(Object element) {
        ArrayList<Object> elements = new ArrayList<Object>();
        while (element != null) {
            elements.add(0, element);
            element = this.getParent(element);
        }
        if (elements.isEmpty()) {
            return TreePath.EMPTY;
        }
        return new TreePath(elements.toArray());
    }

    private Object getParent(Object element) {
        if (this.contentProvider == null) {
            this.contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        }
        return this.contentProvider.getParent(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = this.fProvider.getColumnText(element, columnIndex);
        if (columnIndex == 0) {
            if (this.fDecorator != null) {
                if (this.fDecorator instanceof LabelDecorator) {
                    LabelDecorator ld2 = (LabelDecorator)this.fDecorator;
                    String decorated = ld2.decorateText(text, element, this.getDecorationContext());
                    if (decorated != null) {
                        text = decorated;
                    }
                } else {
                    String decorated = this.fDecorator.decorateText(text, element);
                    if (decorated != null) {
                        text = decorated;
                    }
                }
            }
            IFilterable decorator = this.adaptFilterable(element);
            TreePath path = this.getTreePath(element);
            if (decorator != null && path != null && TreeViewerUtil.isFiltering(this.viewer, path)) {
                text = TreeViewerUtil.getDecoratedText(text, this.viewer, path);
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = super.getImage(element);
        IFilterable decorator = this.adaptFilterable(element);
        TreePath path = this.getTreePath(element);
        if (image != null && decorator != null && path != null && TreeViewerUtil.isFiltering(this.viewer, path)) {
            image = TreeViewerUtil.getDecoratedImage(image, this.viewer, path);
        }
        return image;
    }

    public String getText(Object element) {
        String text = super.getText(element);
        IFilterable decorator = this.adaptFilterable(element);
        TreePath path = this.getTreePath(element);
        if (text != null && decorator != null && path != null && TreeViewerUtil.isFiltering(this.viewer, path)) {
            text = TreeViewerUtil.getDecoratedText(text, this.viewer, path);
        }
        return text;
    }

    private IFilterable adaptFilterable(Object element) {
        IFilterable decorator = null;
        if (element instanceof IFilterable) {
            decorator = (IFilterable)element;
        }
        if (decorator == null && element instanceof IAdaptable) {
            decorator = (IFilterable)((IAdaptable)element).getAdapter(IFilterable.class);
        }
        if (decorator == null) {
            decorator = (IFilterable)Platform.getAdapterManager().getAdapter(element, IFilterable.class);
        }
        return decorator;
    }

    public Font getFont(Object element, int columnIndex) {
        return this.fProvider.getFont(element, columnIndex);
    }

    public Color getForeground(Object element, int columnIndex) {
        return this.fProvider.getForeground(element, columnIndex);
    }

    public Color getBackground(Object element, int columnIndex) {
        return this.fProvider.getBackground(element, columnIndex);
    }
}

