/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.common.notify.AdapterFactory;

public interface GeneratorAdapterFactory
extends AdapterFactory {
    public Generator getGenerator();

    public void setGenerator(Generator var1);

    public void initialize(Object var1);

    public void dispose();

    public static interface Descriptor {
        public GeneratorAdapterFactory createAdapterFactory();

        public static class DelegatingRegistry
        implements Registry {
            protected Registry delegateRegistry;
            protected Map<String, List<Descriptor>> map = new HashMap<String, List<Descriptor>>();

            public DelegatingRegistry() {
            }

            public DelegatingRegistry(Registry delegateRegistry) {
                this.delegateRegistry = delegateRegistry;
            }

            @Override
            public Collection<Descriptor> getDescriptors(String packageID) {
                List<Descriptor> descriptors = this.getDescriptors(packageID, false);
                return descriptors != null && !descriptors.isEmpty() ? new ArrayList<Descriptor>(descriptors) : this.delegatedGetDescriptors(packageID);
            }

            protected Collection<Descriptor> delegatedGetDescriptors(String packageID) {
                return this.delegateRegistry != null ? this.delegateRegistry.getDescriptors(packageID) : Collections.emptyList();
            }

            @Override
            public boolean addDescriptor(String packageID, Descriptor descriptor) {
                return this.getDescriptors(packageID, true).add(descriptor);
            }

            @Override
            public boolean removeDescriptor(String packageID, Descriptor descriptor) {
                List<Descriptor> list = this.getDescriptors(packageID, false);
                if (list != null) {
                    return list.remove(descriptor);
                }
                return false;
            }

            @Override
            public boolean removeDescriptors(String packageID) {
                List<Descriptor> list = this.getDescriptors(packageID, false);
                if (list != null && !list.isEmpty()) {
                    this.map.remove(packageID);
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            protected List<Descriptor> getDescriptors(String packageID, boolean forceCreate) {
                List<Descriptor> result = this.map.get(packageID);
                if (result == null && forceCreate) {
                    result = new ArrayList<Descriptor>();
                    this.map.put(packageID, result);
                }
                return result;
            }
        }

        public static interface Registry {
            public static final Registry INSTANCE = new DelegatingRegistry();

            public Collection<Descriptor> getDescriptors(String var1);

            public boolean addDescriptor(String var1, Descriptor var2);

            public boolean removeDescriptor(String var1, Descriptor var2);

            public boolean removeDescriptors(String var1);

            public void clear();
        }
    }
}

