/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.memorybrowser;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.model.provisional.IRecurringDebugContext;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.MemoryBrowserPlugin;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class GoToAddressBarWidget {
    private static String SEPARATOR = "<seperator>";
    private static String UNKNOWN_CONTEXT_ID = "Unknown";
    private Combo fExpression;
    private ControlDecoration fEmptyExpression;
    private ControlDecoration fWrongExpression;
    private Button fOKButton;
    private Button fOKNewTabButton;
    private Composite fComposite;
    protected static int ID_GO_NEW_TAB = 2000;
    private IStatus fExpressionStatus = Status.OK_STATUS;
    private static final String SAVED_EXPRESSIONS = "saved_expressions";
    private static final int MAX_SAVED_EXPRESSIONS = 15;

    public Control createControl(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fComposite, ".GoToAddressComposite_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fExpression = this.createExpressionField(this.fComposite);
        this.fOKButton = new Button(this.fComposite, 0);
        this.fOKButton.setText(Messages.getString("GoToAddressBarWidget.Go"));
        this.fOKButton.setEnabled(false);
        this.fOKNewTabButton = new Button(this.fComposite, 0);
        this.fOKNewTabButton.setText(Messages.getString("GoToAddressBarWidget.NewTab"));
        this.fOKNewTabButton.setEnabled(false);
        return this.fComposite;
    }

    private void addExpressionToHistoryPersistence(Object context, String expr, String memorySpace) {
        ILaunch launch = this.getLaunch(context);
        if (launch == null) {
            return;
        }
        String contextID = this.getRecurringContextID(context);
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        Object currentExpressions = "";
        if (launchConfiguration != null) {
            try {
                ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
                if (wc != null) {
                    currentExpressions = wc.getAttribute(this.getSaveExpressionKey(contextID, memorySpace), "");
                    StringTokenizer st = new StringTokenizer((String)currentExpressions, ",");
                    ArrayList<String> list = new ArrayList<String>();
                    while (st.hasMoreElements()) {
                        String expression = (String)st.nextElement();
                        list.add(expression);
                    }
                    if (!list.contains(expr)) {
                        list.add(expr);
                        while (list.size() > 15) {
                            list.remove(0);
                        }
                        currentExpressions = "";
                        int idx = 0;
                        while (idx < list.size()) {
                            if (idx > 0) {
                                currentExpressions = (String)currentExpressions + ",";
                            }
                            currentExpressions = (String)currentExpressions + (String)list.get(idx);
                            ++idx;
                        }
                        wc.setAttribute(this.getSaveExpressionKey(contextID, memorySpace), (String)currentExpressions);
                        wc.doSave();
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void clearExpressionHistoryPersistence(Object context) {
        if (context == null) {
            return;
        }
        ILaunch launch = this.getLaunch(context);
        if (launch == null) {
            return;
        }
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration != null) {
            try {
                ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
                if (wc != null) {
                    Map attributes = wc.getAttributes();
                    for (String key : attributes.keySet()) {
                        if (!key.startsWith(SAVED_EXPRESSIONS)) continue;
                        wc.removeAttribute(key);
                    }
                    wc.doSave();
                }
            }
            catch (CoreException e) {
                MemoryBrowserPlugin.log(e);
            }
        }
    }

    private String[] getSavedExpressions(Object context, String memorySpace) throws CoreException {
        ILaunch launch = this.getLaunch(context);
        if (launch == null) {
            return new String[0];
        }
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        String expressions = "";
        if (launchConfiguration != null) {
            expressions = launchConfiguration.getAttribute(this.getSaveExpressionKey(this.getRecurringContextID(context), memorySpace), "");
        }
        StringTokenizer st = new StringTokenizer(expressions, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public void loadSavedExpressions(Object context, String memorySpace) {
        try {
            String[] expressions = this.getSavedExpressions(context, memorySpace);
            String currentExpression = this.fExpression.getText();
            if (currentExpression.length() > 0) {
                int index = this.fExpression.indexOf(currentExpression);
                if (index > 0) {
                    this.fExpression.remove(0, index - 1);
                }
                index = this.fExpression.indexOf(currentExpression);
                if (this.fExpression.getItemCount() - index - 1 > 1) {
                    this.fExpression.remove(index + 1, this.fExpression.getItemCount() - 1);
                }
            } else {
                this.fExpression.removeAll();
            }
            String[] stringArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                String expression = stringArray[n2];
                if (this.fExpression.indexOf(expression) < 0) {
                    this.fExpression.add(expression);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MemoryBrowserPlugin.log(e);
        }
    }

    public void addExpressionToHistory(Object context, String expr, String memorySpace) {
        if (this.fExpression.indexOf(expr) == -1) {
            while (this.fExpression.getItemCount() >= 15) {
                this.fExpression.remove(0);
            }
            this.fExpression.add(expr);
        }
        this.addExpressionToHistoryPersistence(context, expr, memorySpace);
    }

    public void clearExpressionHistory(Object context) {
        this.fExpression.removeAll();
        this.fExpression.computeSize(-1, -1, true);
        this.clearExpressionHistoryPersistence(context);
        this.handleExpressionStatus(Status.OK_STATUS);
    }

    private Combo createExpressionField(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GoToAddressBarWidget.this.updateButtons();
            }
        });
        this.fEmptyExpression = new ControlDecoration((Control)combo, 0x1004000);
        this.fEmptyExpression.setDescriptionText(Messages.getString("GoToAddressBarWidget.EnterExpressionMessage"));
        FieldDecoration fieldDec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
        this.fEmptyExpression.setImage(fieldDec.getImage());
        this.fWrongExpression = new ControlDecoration((Control)combo, 16512);
        fieldDec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.fWrongExpression.setImage(fieldDec.getImage());
        this.fWrongExpression.hide();
        GridData data = new GridData(768);
        data.horizontalIndent = Math.max(this.fEmptyExpression.getImage().getBounds().width, this.fWrongExpression.getImage().getBounds().width);
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected void updateButtons() {
        boolean empty = this.getExpressionText().length() == 0;
        this.fOKNewTabButton.setEnabled(!empty);
        this.fOKButton.setEnabled(!empty);
        if (empty) {
            this.fEmptyExpression.show();
        } else {
            this.fEmptyExpression.hide();
        }
        if (this.fExpressionStatus.isOK()) {
            this.fWrongExpression.hide();
        } else {
            this.fWrongExpression.show();
        }
    }

    public int getHeight() {
        int height = this.fComposite.computeSize((int)-1, (int)-1).y;
        return height;
    }

    public Button getButton(int id) {
        if (id == 0) {
            return this.fOKButton;
        }
        if (id == ID_GO_NEW_TAB) {
            return this.fOKNewTabButton;
        }
        return null;
    }

    public String getExpressionText() {
        return this.fExpression.getText().trim();
    }

    public void setExpressionText(String text) {
        this.fExpression.setText(text);
    }

    public Combo getExpressionWidget() {
        return this.fExpression;
    }

    public void handleExpressionStatus(IStatus message) {
        if (message.isOK()) {
            this.fWrongExpression.hide();
        } else {
            this.fWrongExpression.setDescriptionText(message.getMessage());
            this.fWrongExpression.show();
        }
        this.fExpressionStatus = message;
    }

    public IStatus getExpressionStatus() {
        return this.fExpressionStatus;
    }

    private ILaunch getLaunch(Object context) {
        IAdaptable adaptable = null;
        ILaunch launch = null;
        if (context instanceof IAdaptable) {
            adaptable = (IAdaptable)context;
            launch = (ILaunch)adaptable.getAdapter(ILaunch.class);
        }
        return launch;
    }

    private String getRecurringContextID(Object context) {
        IAdaptable adaptable;
        IRecurringDebugContext recurringDebugContext;
        String id = UNKNOWN_CONTEXT_ID;
        if (context instanceof IAdaptable && (recurringDebugContext = (IRecurringDebugContext)(adaptable = (IAdaptable)context).getAdapter(IRecurringDebugContext.class)) != null) {
            try {
                id = recurringDebugContext.getContextID();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return id;
    }

    private String getSaveExpressionKey(String contextID, String memorySpace) {
        assert (contextID.length() > 0);
        String key = SAVED_EXPRESSIONS + SEPARATOR + contextID;
        if (memorySpace != null && memorySpace.length() > 0) {
            key = key + SEPARATOR + memorySpace;
        }
        return key;
    }
}

