/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jvm;

import java.text.MessageFormat;
import org.eclipse.net4j.TransportConfigurator;
import org.eclipse.net4j.internal.jvm.JVMAcceptorManager;
import org.eclipse.net4j.internal.jvm.JVMClientConnector;
import org.eclipse.net4j.internal.jvm.JVMServerConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.spi.net4j.Acceptor;
import org.eclipse.spi.net4j.InternalConnector;
import org.w3c.dom.Element;

public class JVMAcceptor
extends Acceptor
implements IJVMAcceptor {
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JVMServerConnector handleAccept(JVMClientConnector client) {
        JVMServerConnector connector = new JVMServerConnector(this, client);
        this.prepareConnector((InternalConnector)connector);
        connector.setName(client.getName());
        connector.activate();
        this.addConnector((InternalConnector)connector);
        return connector;
    }

    public String toString() {
        return MessageFormat.format("JVMAcceptor[{0}]", this.name);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (StringUtil.isEmpty((String)this.name)) {
            throw new IllegalStateException("No name");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        JVMAcceptorManager.INSTANCE.registerAcceptor(this);
    }

    protected void doDeactivate() throws Exception {
        JVMAcceptorManager.INSTANCE.deregisterAcceptor(this);
        super.doDeactivate();
    }

    public static class DescriptionParserFactory
    extends TransportConfigurator.AcceptorDescriptionParser.Factory
    implements TransportConfigurator.AcceptorDescriptionParser {
        public DescriptionParserFactory() {
            super("jvm");
        }

        public TransportConfigurator.AcceptorDescriptionParser create(String description) throws ProductCreationException {
            return this;
        }

        public String getAcceptorDescription(Element acceptorConfig) {
            return acceptorConfig.getAttribute("name");
        }
    }
}

