/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.Reader;

public class LimitedReader
extends Reader {
    private final Reader in;
    private final boolean closeBackingReader;
    private long remaining;
    private long remainingAtMark = 0L;

    public LimitedReader(Reader in, long length, boolean closeBackingReader) {
        this.in = in;
        this.remaining = length;
        this.closeBackingReader = closeBackingReader;
    }

    public LimitedReader(Reader in, long length) {
        this(in, length, true);
    }

    @Override
    public int read() throws IOException {
        if (--this.remaining < 0L) {
            return -1;
        }
        return this.in.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        this.remaining = (len = this.in.read(cbuf, off, len)) > 0 ? (this.remaining -= (long)len) : (this.remaining -= this.remaining);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > this.remaining) {
            n = this.remaining;
        }
        n = this.in.skip(n);
        this.remaining -= n;
        return n;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void mark(int readlimit) throws IOException {
        if (this.markSupported()) {
            this.in.mark(readlimit);
            this.remainingAtMark = this.remaining;
        }
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.remaining = this.remainingAtMark;
    }

    @Override
    public void close() throws IOException {
        this.remaining = 0L;
        if (this.closeBackingReader) {
            this.in.close();
        }
    }
}

