/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshSemanticOrderingsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.tool.ToolCommandBuilder;
import org.eclipse.sirius.diagram.sequence.description.tool.ReorderTool;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.tools.api.command.SiriusCommand;

public class SynchronizeISequenceEventsSemanticOrderingOperation
extends AbstractModelChangeOperation<Void> {
    private static final boolean STARTING_END = true;
    private static final boolean FINISHING_END = false;
    private ISequenceEvent event;
    private final Set<ISequenceEvent> selection = new LinkedHashSet<ISequenceEvent>();
    private final SequenceDDiagram sequenceDiagram;
    private final SequenceDiagram diagram;
    private final Set<ISequenceEvent> reordered = new HashSet<ISequenceEvent>();
    private final Set<ISequenceEvent> allElementsToReorder = new LinkedHashSet<ISequenceEvent>();

    public SynchronizeISequenceEventsSemanticOrderingOperation(ISequenceEvent event) {
        super(Messages.SynchronizeISequenceEventsSemanticOrderingOperation_operationName);
        this.event = Objects.requireNonNull(event);
        this.diagram = event.getDiagram();
        this.sequenceDiagram = this.diagram.getSequenceDDiagram();
    }

    public SynchronizeISequenceEventsSemanticOrderingOperation(ISequenceEvent event, Collection<ISequenceEvent> selection) {
        this(event);
        Objects.requireNonNull(selection);
        this.selection.addAll(selection);
    }

    public Void execute() {
        DDiagramElement dde;
        Collection<ISequenceEvent> events;
        if (this.event instanceof AbstractNodeEvent && this.event.getParentEvent() == null && !(events = ISequenceElementAccessor.getEventsForSemanticElement(this.diagram, (dde = (DDiagramElement)this.event.getNotationView().getElement()).getTarget())).isEmpty()) {
            this.event = events.iterator().next();
        }
        Iterables.addAll(this.allElementsToReorder, new ISequenceEventQuery(this.event).getAllSequenceEventToMoveWith(this.selection));
        this.updateSemanticPositions();
        return null;
    }

    private void updateSemanticPositions() {
        this.updateSemanticPosition(this.event);
        for (ISequenceEvent selected : this.selection) {
            this.updateSemanticPosition(selected);
        }
    }

    private void updateSemanticPosition(ISequenceEvent eventToUpdate) {
        DDiagramElement dde = this.resolveDiagramElement(eventToUpdate);
        if (dde == null || this.reordered.contains(eventToUpdate)) {
            return;
        }
        ReorderTool reorderTool = this.findReorderTool(dde);
        if (reorderTool == null) {
            return;
        }
        EObject semanticElement = dde.getTarget();
        EList endsBySemanticOrder = this.sequenceDiagram.getSemanticOrdering().getEventEnds();
        EList endsByGraphicalOrder = this.sequenceDiagram.getGraphicalOrdering().getEventEnds();
        List<EventEnd> ends = EventEndHelper.findEndsFromSemanticOrdering(eventToUpdate);
        List<EventEnd> compoundEnds = this.getCompoundEnds(eventToUpdate, ends);
        Set<EventEnd> toIgnore = this.selectEndsToIgnore(eventToUpdate, (List<EventEnd>)endsBySemanticOrder, ends, compoundEnds);
        EventEnd startingEndPredecessorBefore = this.findEndPredecessor(semanticElement, true, (List<EventEnd>)endsBySemanticOrder, toIgnore);
        EventEnd finishingEndPredecessorBefore = this.findEndPredecessor(semanticElement, false, (List<EventEnd>)endsBySemanticOrder, toIgnore);
        EventEnd startingEndPredecessorAfter = this.findEndPredecessor(semanticElement, true, (List<EventEnd>)endsByGraphicalOrder, toIgnore);
        EventEnd finishingEndPredecessorAfter = this.findEndPredecessor(semanticElement, false, (List<EventEnd>)endsByGraphicalOrder, toIgnore);
        if (eventToUpdate.isLogicallyInstantaneous() && eventToUpdate instanceof Message && ends.size() == 1 && !Iterables.any(ends, (Predicate)Predicates.instanceOf(CompoundEventEnd.class))) {
            SingleEventEnd see = (SingleEventEnd)ends.iterator().next();
            if (see.isStart()) {
                finishingEndPredecessorBefore = startingEndPredecessorBefore;
                finishingEndPredecessorAfter = startingEndPredecessorAfter;
            } else {
                startingEndPredecessorBefore = finishingEndPredecessorBefore;
                startingEndPredecessorAfter = finishingEndPredecessorAfter;
            }
        }
        if (!(Objects.equals(startingEndPredecessorBefore, startingEndPredecessorAfter) && Objects.equals(finishingEndPredecessorBefore, finishingEndPredecessorAfter) && Iterables.elementsEqual((Iterable)endsByGraphicalOrder, (Iterable)endsBySemanticOrder))) {
            this.applySemanticReordering(semanticElement, startingEndPredecessorAfter, finishingEndPredecessorAfter, reorderTool);
            this.applyCompoundReordering(semanticElement, ends, compoundEnds, startingEndPredecessorAfter, finishingEndPredecessorAfter, reorderTool);
            this.reordered.add(eventToUpdate);
            new RefreshSemanticOrderingsOperation(this.sequenceDiagram).execute();
            this.updateSubEventsSemanticPositions(eventToUpdate);
        }
    }

    private DDiagramElement resolveDiagramElement(ISequenceEvent eventToUpdate) {
        EObject element = eventToUpdate.getNotationView().getElement();
        if (element instanceof DDiagramElement) {
            return (DDiagramElement)element;
        }
        throw new RuntimeException(MessageFormat.format(Messages.SynchronizeISequenceEventsSemanticOrderingOperation_invalidISequenceEventContext, eventToUpdate));
    }

    private List<EventEnd> getCompoundEnds(ISequenceEvent eventToUpdate, List<EventEnd> ends) {
        List<ISequenceEvent> compoundEvents = EventEndHelper.getCompoundEvents(eventToUpdate);
        Predicate<ISequenceEvent> isLogicallyInstantaneousNonReorderedEvent = new Predicate<ISequenceEvent>(){

            public boolean apply(ISequenceEvent input) {
                return input.isLogicallyInstantaneous() && !SynchronizeISequenceEventsSemanticOrderingOperation.this.reordered.contains(input);
            }
        };
        Iterable compoundEventsToReorder = Iterables.filter(compoundEvents, (Predicate)isLogicallyInstantaneousNonReorderedEvent);
        Iterable nonReorderedEndsOfCompoundEvents = Iterables.concat((Iterable)Iterables.transform((Iterable)compoundEventsToReorder, EventEndHelper.EVENT_ENDS));
        Predicate isCompoundEnd = Predicates.and((Predicate)Predicates.instanceOf(SingleEventEnd.class), (Predicate)Predicates.not((Predicate)Predicates.in(ends)));
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)nonReorderedEndsOfCompoundEvents, (Predicate)isCompoundEnd));
    }

    private void updateSubEventsSemanticPositions(ISequenceEvent eventToUpdate) {
        for (ISequenceEvent subEvent : eventToUpdate.getEventsToMoveWith()) {
            this.updateSemanticPosition(subEvent);
        }
    }

    private void applyCompoundReordering(EObject semanticElement, List<EventEnd> ends, List<EventEnd> compoundEnds, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, ReorderTool reorderTool) {
        if (compoundEnds.isEmpty() || ends.size() != 2) {
            return;
        }
        EventEnd startEventEnd = null;
        EventEnd endEventEnd = null;
        List<Object> startSemanticEvents = new ArrayList();
        for (EventEnd ee : ends) {
            SingleEventEnd see = EventEndHelper.getSingleEventEnd(ee, semanticElement);
            if (see.isStart()) {
                startEventEnd = ee;
                startSemanticEvents = EventEndHelper.getSemanticEvents(startEventEnd);
                continue;
            }
            endEventEnd = ee;
        }
        for (EventEnd ee : compoundEnds) {
            List<EObject> eeSemElts = EventEndHelper.getSemanticEvents(ee);
            EventEnd otherEnd = Iterables.any(eeSemElts, (Predicate)Predicates.in(startSemanticEvents)) ? startEventEnd : endEventEnd;
            EventEnd predecessor = Iterables.any(eeSemElts, (Predicate)Predicates.in(startSemanticEvents)) ? startingEndPredecessor : finishingEndPredecessor;
            for (EObject elt : eeSemElts) {
                SingleEventEnd singleEventEnd = EventEndHelper.getSingleEventEnd(otherEnd, elt);
                ISequenceEvent ise = EventEndHelper.findISequenceEvent(singleEventEnd, this.diagram);
                if (!singleEventEnd.isStart()) {
                    this.applySemanticReordering(elt, predecessor, ee, reorderTool);
                } else {
                    this.applySemanticReordering(elt, predecessor, otherEnd, reorderTool);
                }
                this.reordered.add(ise);
            }
        }
    }

    private Set<EventEnd> selectEndsToIgnore(ISequenceEvent ise, List<EventEnd> endsBySemanticOrder, final List<EventEnd> iseEnds, List<EventEnd> compoundEnds) {
        Iterable movedElements = Iterables.filter(this.allElementsToReorder, (Predicate)Predicates.not((Predicate)Predicates.in(this.reordered)));
        final HashSet semanticLinked = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)movedElements, ISequenceElement.SEMANTIC_TARGET), (Predicate)Predicates.notNull()));
        Predicate<EObject> isLinkedSubEventEnd = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return semanticLinked.contains(input);
            }
        };
        final HashSet semanticDescendants = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(new ISequenceEventQuery(ise).getAllDescendants(), ISequenceElement.SEMANTIC_TARGET), (Predicate)Predicates.notNull()));
        Predicate<EObject> isSemanticSubEventEnd = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return semanticDescendants.contains(input);
            }
        };
        Predicate<EventEnd> toIgnore = new Predicate<EventEnd>((Predicate)isSemanticSubEventEnd, (Predicate)isLinkedSubEventEnd, compoundEnds){
            private final /* synthetic */ Predicate val$isSemanticSubEventEnd;
            private final /* synthetic */ Predicate val$isLinkedSubEventEnd;
            private final /* synthetic */ List val$compoundEnds;
            {
                this.val$isSemanticSubEventEnd = predicate;
                this.val$isLinkedSubEventEnd = predicate2;
                this.val$compoundEnds = list2;
            }

            public boolean apply(EventEnd input) {
                return !iseEnds.contains(input) && (Iterables.any(EventEndHelper.getSemanticEvents(input), (Predicate)Predicates.or((Predicate)this.val$isSemanticSubEventEnd, (Predicate)this.val$isLinkedSubEventEnd)) || this.val$compoundEnds.contains(input));
            }
        };
        HashSet newHashSet = Sets.newHashSet((Iterable)Iterables.filter(endsBySemanticOrder, (Predicate)toIgnore));
        return newHashSet;
    }

    private EventEnd findEndPredecessor(EObject semanticElement, boolean startingEnd, List<EventEnd> eventEnds, Set<EventEnd> toIgnore) {
        EventEnd result = null;
        for (EventEnd end : Iterables.filter(eventEnds, (Predicate)Predicates.not((Predicate)Predicates.in(toIgnore)))) {
            if (this.isLookedEnd(semanticElement, startingEnd, end)) break;
            result = end;
        }
        return result;
    }

    private boolean isLookedEnd(EObject semanticElement, boolean startingEnd, EventEnd end) {
        boolean currentMovedEnd = false;
        List<EObject> semanticEvents = EventEndHelper.getSemanticEvents(end);
        if (semanticEvents.contains(semanticElement)) {
            boolean lookedEventEnd = EventEndHelper.getSingleEventEnd(end, semanticElement).isStart() == startingEnd;
            boolean punctualCompoundEvent = EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)end);
            currentMovedEnd = lookedEventEnd || punctualCompoundEvent;
        }
        return currentMovedEnd;
    }

    private void applySemanticReordering(EObject semanticElement, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, ReorderTool reorderTool) {
        SiriusCommand cmd = ToolCommandBuilder.buildReorderCommand(this.sequenceDiagram, reorderTool, semanticElement, startingEndPredecessor, finishingEndPredecessor);
        cmd.execute();
    }

    private ReorderTool findReorderTool(DDiagramElement diagramElement) {
        if (diagramElement != null) {
            Session session = SessionManager.INSTANCE.getSession((EObject)diagramElement);
            Collection allTools = session != null ? new DiagramComponentizationManager().getAllTools(session.getSelectedViewpoints(false), this.sequenceDiagram.getDescription()) : new DiagramDescriptionQuery(this.sequenceDiagram.getDescription()).getAllTools();
            DiagramElementMapping mappingToCheck = new DiagramElementMappingQuery(diagramElement.getDiagramElementMapping()).getRootMapping();
            for (ReorderTool toolDesc : Iterables.filter((Iterable)allTools, ReorderTool.class)) {
                if (!toolDesc.getMappings().contains((Object)mappingToCheck)) continue;
                return toolDesc;
            }
        }
        return null;
    }
}

