/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.ColorManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPreferenceInitializer;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.ImageDescriptorRegistry;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.launchConfigurations.ClosedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.DeletedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationEditDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPropertiesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerManager;
import org.eclipse.debug.internal.ui.views.console.ProcessConsoleManager;
import org.eclipse.debug.internal.ui.views.launch.DebugElementHelper;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;

public class DebugUIPlugin
extends AbstractUIPlugin
implements ILaunchListener,
DebugOptionsListener {
    public static boolean DEBUG = false;
    public static boolean DEBUG_BREAKPOINT_DELTAS = false;
    public static boolean DEBUG_MODEL = false;
    public static boolean DEBUG_VIEWER = false;
    public static boolean DEBUG_BREADCRUMB = false;
    public static boolean DEBUG_TREE_VIEWER_DROPDOWN = false;
    public static boolean DEBUG_CONTENT_PROVIDER = false;
    public static boolean DEBUG_UPDATE_SEQUENCE = false;
    public static boolean DEBUG_DELTAS = false;
    public static boolean DEBUG_STATE_SAVE_RESTORE = false;
    public static String DEBUG_PRESENTATION_ID = null;
    public static boolean DEBUG_DYNAMIC_LOADING = false;
    public static boolean DEBUG_COMMAND_SERVICE = false;
    static final String DEBUG_FLAG = "org.eclipse.debug.ui/debug";
    static final String DEBUG_BREAKPOINT_DELTAS_FLAG = "org.eclipse.debug.ui/debug/viewers/breakpointDeltas";
    static final String DEBUG_MODEL_FLAG = "org.eclipse.debug.ui/debug/viewers/model";
    static final String DEBUG_VIEWER_FLAG = "org.eclipse.debug.ui/debug/viewers/viewer";
    static final String DEBUG_BREADCRUMB_FLAG = "org.eclipse.debug.ui/debug/breadcrumb";
    static final String DEBUG_TREE_VIEWER_DROPDOWN_FLAG = "org.eclipse.debug.ui/debug/breadcrumb";
    static final String DEBUG_CONTENT_PROVIDER_FLAG = "org.eclipse.debug.ui/debug/viewers/contentProvider";
    static final String DEBUG_UPDATE_SEQUENCE_FLAG = "org.eclipse.debug.ui/debug/viewers/updateSequence";
    static final String DEBUG_DELTAS_FLAG = "org.eclipse.debug.ui/debug/viewers/deltas";
    static final String DEBUG_STATE_SAVE_RESTORE_FLAG = "org.eclipse.debug.ui/debug/viewers/stateSaveRestore";
    static final String DEBUG_PRESENTATION_ID_FLAG = "org.eclipse.debug.ui/debug/viewers/presentationId";
    static final String DEBUG_DYNAMIC_LOADING_FLAG = "org.eclipse.debug.ui/debug/memory/dynamicLoading";
    static final String DEBUG_COMMAND_SERVICE_FLAG = "org.eclipse.debug.ui/debug/commandservice";
    private static DebugTrace fgDebugTrace;
    private static DebugUIPlugin fgDebugUIPlugin;
    protected static IDebugModelPresentation fgPresentation;
    private static DefaultLabelProvider fgDefaultLabelProvider;
    public static String ATTR_LAUNCHING_CONFIG_HANDLE;
    private ProcessConsoleManager fProcessConsoleManager = null;
    private PerspectiveManager fPerspectiveManager = null;
    private LaunchConfigurationManager fLaunchConfigurationManager = null;
    private LaunchingResourceManager fContextLaunchingManager = null;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private final Set<ISaveParticipant> fSaveParticipants = new LinkedHashSet<ISaveParticipant>();
    private IPropertyChangeListener fThemeListener;

    static {
        fgDebugUIPlugin = null;
        fgPresentation = null;
        ATTR_LAUNCHING_CONFIG_HANDLE = DebugUIPlugin.getUniqueIdentifier() + "launching_config_handle";
    }

    public DebugUIPlugin() {
        fgDebugUIPlugin = this;
    }

    public static void trace(String option, String message, Throwable throwable) {
        if (fgDebugTrace != null) {
            fgDebugTrace.trace(option, message, throwable);
        } else {
            System.out.println(message);
        }
    }

    public static void trace(String message) {
        DebugUIPlugin.trace(null, message, null);
    }

    public static DebugUIPlugin getDefault() {
        if (fgDebugUIPlugin == null) {
            fgDebugUIPlugin = new DebugUIPlugin();
        }
        return fgDebugUIPlugin;
    }

    public static String getUniqueIdentifier() {
        return "org.eclipse.debug.ui";
    }

    public static IDebugModelPresentation getModelPresentation() {
        if (fgPresentation == null) {
            fgPresentation = new DelegatingModelPresentation();
        }
        return fgPresentation;
    }

    public LaunchConfigurationManager getLaunchConfigurationManager() {
        if (this.fLaunchConfigurationManager == null) {
            this.fLaunchConfigurationManager = new LaunchConfigurationManager();
        }
        return this.fLaunchConfigurationManager;
    }

    public LaunchingResourceManager getLaunchingResourceManager() {
        if (this.fContextLaunchingManager == null) {
            this.fContextLaunchingManager = new LaunchingResourceManager();
            this.fContextLaunchingManager.startup();
        }
        return this.fContextLaunchingManager;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static Shell getShellForModalDialog() {
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        if (shell == null) {
            shell = DebugUIPlugin.getShell();
        }
        return shell;
    }

    public static ILabelProvider getDefaultLabelProvider() {
        if (fgDefaultLabelProvider == null) {
            fgDefaultLabelProvider = new DefaultLabelProvider();
        }
        return fgDefaultLabelProvider;
    }

    public static Object createExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        if (bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        Object[] ret = new Object[1];
        CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, () -> {
            try {
                objectArray[0] = element.createExecutableExtension(classAttribute);
            }
            catch (CoreException e) {
                coreExceptionArray[0] = e;
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    protected ImageRegistry createImageRegistry() {
        return DebugPluginImages.initializeImageRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fProcessConsoleManager != null) {
                this.fProcessConsoleManager.shutdown();
            }
            BreakpointOrganizerManager.getDefault().shutdown();
            if (this.fPerspectiveManager != null) {
                this.fPerspectiveManager.shutdown();
            }
            if (this.fLaunchConfigurationManager != null) {
                this.fLaunchConfigurationManager.shutdown();
            }
            if (this.fContextLaunchingManager != null) {
                this.fContextLaunchingManager.shutdown();
            }
            if (fgPresentation != null) {
                fgPresentation.dispose();
            }
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
            if (fgDefaultLabelProvider != null) {
                fgDefaultLabelProvider.dispose();
            }
            SourceLookupFacility.shutdown();
            DebugElementHelper.dispose();
            Set<ISaveParticipant> set = this.fSaveParticipants;
            synchronized (set) {
                this.fSaveParticipants.clear();
            }
            ResourcesPlugin.getWorkspace().removeSaveParticipant(DebugUIPlugin.getUniqueIdentifier());
            if (this.fThemeListener != null) {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fThemeListener);
                }
                this.fThemeListener = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSaveParticipant(ISaveParticipant participant) {
        boolean added;
        Set<ISaveParticipant> set = this.fSaveParticipants;
        synchronized (set) {
            added = this.fSaveParticipants.add(participant);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSaveParticipant(ISaveParticipant participant) {
        boolean removed;
        Set<ISaveParticipant> set = this.fSaveParticipants;
        synchronized (set) {
            removed = this.fSaveParticipants.remove(participant);
        }
        return removed;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", DebugUIPlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.fPerspectiveManager = new PerspectiveManager();
        this.fPerspectiveManager.startup();
        this.getLaunchingResourceManager();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        if (launches.length > 0) {
            this.initializeLaunchListeners();
        } else {
            launchManager.addLaunchListener((ILaunchListener)this);
        }
        BreakpointOrganizerManager.getDefault();
        this.getLaunchConfigurationManager().startup();
        if (PlatformUI.isWorkbenchRunning()) {
            this.fThemeListener = event -> {
                if ("CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                    DebugUIPreferenceInitializer.setThemeBasedPreferences(this.getPreferenceStore(), true);
                }
            };
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fThemeListener);
        }
        DebugUIPlugin.getStandardDisplay().asyncExec(() -> {
            SelectedResourceManager.getDefault();
            this.getLaunchConfigurationManager().getLaunchShortcuts();
        });
        class DebugUIPluginSaveParticipant
        implements ISaveParticipant {
            DebugUIPluginSaveParticipant() {
            }

            public void saving(ISaveContext saveContext) throws CoreException {
                IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
                if (node != null) {
                    try {
                        node.flush();
                    }
                    catch (BackingStoreException e) {
                        DebugUIPlugin.log(e);
                    }
                }
                Set<ISaveParticipant> saveParticipants = DebugUIPlugin.this.getSaveParticipants();
                for (ISaveParticipant sp : saveParticipants) {
                    sp.saving(saveContext);
                }
            }

            public void rollback(ISaveContext saveContext) {
                Set<ISaveParticipant> saveParticipants = DebugUIPlugin.this.getSaveParticipants();
                for (ISaveParticipant sp : saveParticipants) {
                    sp.rollback(saveContext);
                }
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
                Set<ISaveParticipant> saveParticipants = DebugUIPlugin.this.getSaveParticipants();
                for (ISaveParticipant sp : saveParticipants) {
                    sp.prepareToSave(saveContext);
                }
            }

            public void doneSaving(ISaveContext saveContext) {
                Set<ISaveParticipant> saveParticipants = DebugUIPlugin.this.getSaveParticipants();
                for (ISaveParticipant sp : saveParticipants) {
                    sp.doneSaving(saveContext);
                }
            }
        }
        DebugUIPluginSaveParticipant saveParticipant = new DebugUIPluginSaveParticipant();
        ResourcesPlugin.getWorkspace().addSaveParticipant(DebugUIPlugin.getUniqueIdentifier(), (ISaveParticipant)saveParticipant);
    }

    public void optionsChanged(DebugOptions options) {
        fgDebugTrace = options.newDebugTrace(DebugUIPlugin.getUniqueIdentifier());
        DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
        DEBUG_BREAKPOINT_DELTAS = DEBUG && options.getBooleanOption(DEBUG_BREAKPOINT_DELTAS_FLAG, false);
        DEBUG_MODEL = DEBUG && options.getBooleanOption(DEBUG_MODEL_FLAG, false);
        DEBUG_VIEWER = DEBUG && options.getBooleanOption(DEBUG_VIEWER_FLAG, false);
        DEBUG_BREADCRUMB = DEBUG && options.getBooleanOption("org.eclipse.debug.ui/debug/breadcrumb", false);
        DEBUG_TREE_VIEWER_DROPDOWN = DEBUG && options.getBooleanOption("org.eclipse.debug.ui/debug/breadcrumb", false);
        DEBUG_CONTENT_PROVIDER = DEBUG && options.getBooleanOption(DEBUG_CONTENT_PROVIDER_FLAG, false);
        DEBUG_UPDATE_SEQUENCE = DEBUG && options.getBooleanOption(DEBUG_UPDATE_SEQUENCE_FLAG, false);
        DEBUG_DELTAS = DEBUG && options.getBooleanOption(DEBUG_DELTAS_FLAG, false);
        DEBUG_STATE_SAVE_RESTORE = DEBUG && options.getBooleanOption(DEBUG_STATE_SAVE_RESTORE_FLAG, false);
        DEBUG_DYNAMIC_LOADING = DEBUG && options.getBooleanOption(DEBUG_DYNAMIC_LOADING_FLAG, false);
        boolean bl = DEBUG_COMMAND_SERVICE = DEBUG && options.getBooleanOption(DEBUG_COMMAND_SERVICE_FLAG, false);
        if (DEBUG && "".equals(DEBUG_PRESENTATION_ID = options.getOption(DEBUG_PRESENTATION_ID_FLAG, ""))) {
            DEBUG_PRESENTATION_ID = null;
        }
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "Error within Debug UI: ", t);
            DebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static void log(IStatus status) {
        DebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Error logged from Debug UI: ", t));
    }

    public static void logErrorMessage(String message) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Internal message logged from Debug UI: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, message, exception);
    }

    public static int openLaunchConfigurationEditDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status, boolean showCancel) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationEditDialog dialog = new LaunchConfigurationEditDialog(shell, configuration, group, showCancel);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, Set<String> reservednames, IStatus status, boolean setDefaults) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationPropertiesDialog dialog = new LaunchConfigurationPropertiesDialog(shell, configuration, group, reservednames);
            dialog.setInitialStatus(status);
            dialog.setDefaultsOnOpen(setDefaults);
            return dialog.open();
        }
        return 1;
    }

    public static int openLaunchConfigurationsDialog(Shell shell, IStructuredSelection selection, String groupIdentifier, boolean setDefaults) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(shell, group);
            dialog.setOpenMode(3);
            dialog.setInitialSelection(selection);
            dialog.setDefaultsOnOpen(setDefaults);
            return dialog.open();
        }
        return 1;
    }

    @Deprecated
    protected static boolean saveAllEditors(boolean confirm) {
        if (DebugUIPlugin.getActiveWorkbenchWindow() == null) {
            return false;
        }
        return PlatformUI.getWorkbench().saveAllEditors(confirm);
    }

    @Deprecated(forRemoval=true, since="2023-12")
    public static boolean saveAndBuild() {
        boolean status = true;
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.save_dirty_editors_before_launch");
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.build_before_launch");
        if (saveDirty.equals("never")) {
            if (buildBeforeLaunch) {
                return DebugUIPlugin.doBuild();
            }
        } else {
            status = DebugUIPlugin.saveAllEditors(saveDirty.equals("prompt"));
            if (status && buildBeforeLaunch) {
                status = DebugUIPlugin.doBuild();
            }
        }
        return status;
    }

    private static boolean doBuild() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    ResourcesPlugin.getWorkspace().build(10, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            String title = DebugUIMessages.DebugUIPlugin_Run_Debug_1;
            String message = DebugUIMessages.DebugUIPlugin_Build_error__Check_log_for_details__2;
            Throwable t = e.getTargetException();
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), title, message, t);
            return false;
        }
        return true;
    }

    public static Display getStandardDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    public ProcessConsoleManager getProcessConsoleManager() {
        if (this.fProcessConsoleManager == null) {
            this.fProcessConsoleManager = new ProcessConsoleManager();
        }
        return this.fProcessConsoleManager;
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilder docBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
        return docBuilder.newDocument();
    }

    public void launchAdded(ILaunch launch) {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.initializeLaunchListeners();
    }

    private void initializeLaunchListeners() {
        this.getProcessConsoleManager().startup();
        SourceLookupManager.getDefault();
    }

    public PerspectiveManager getPerspectiveManager() {
        return this.fPerspectiveManager;
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public static final String formatKeyBindingString(int modifierKeys, String keyOrClick) {
        return KeyStroke.getInstance((int)modifierKeys, (int)0).format() + keyOrClick;
    }

    public static boolean DEBUG_TEST_PRESENTATION_ID(IPresentationContext context) {
        if (context == null) {
            return true;
        }
        return DEBUG_PRESENTATION_ID == null || DEBUG_PRESENTATION_ID.equals(context.getId());
    }

    public static ILaunch getLaunch(Object element) {
        ILaunch launch = (ILaunch)DebugPlugin.getAdapter((Object)element, ILaunch.class);
        if (launch == null) {
            if (element instanceof IDebugElement) {
                launch = ((IDebugElement)element).getLaunch();
            } else if (element instanceof ILaunch) {
                launch = (ILaunch)element;
            } else if (element instanceof IProcess) {
                launch = ((IProcess)element).getLaunch();
            }
        }
        return launch;
    }

    @Deprecated
    public static boolean preLaunchSave() {
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.save_dirty_editors_before_launch");
        if (saveDirty.equals("never")) {
            return true;
        }
        return DebugUIPlugin.saveAllEditors(saveDirty.equals("prompt"));
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.build_before_launch");
        return configuration.launch(mode, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), buildBeforeLaunch);
    }

    public static void launchInForeground(ILaunchConfiguration configuration, String mode) {
        IJobManager jobManager = Job.getJobManager();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean wait = false;
        if (jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0) {
            String waitForBuild = store.getString("org.eclipse.debug.ui.wait_for_build");
            if (waitForBuild.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)DebugUIPlugin.getShell(), (String)DebugUIMessages.DebugUIPlugin_23, (String)DebugUIMessages.DebugUIPlugin_24, null, (boolean)false, (IPreferenceStore)store, (String)"org.eclipse.debug.ui.wait_for_build");
                switch (dialog.getReturnCode()) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        wait = false;
                        break;
                    }
                    case 3: {
                        wait = true;
                        break;
                    }
                }
            } else if (waitForBuild.equals("always")) {
                wait = true;
            }
        }
        if (wait) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IProgressService progressService = workbench.getProgressService();
            IRunnableWithProgress runnable = monitor -> {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(DebugUIMessages.DebugUIPlugin_25, configuration.getName()), (int)100);
                try {
                    jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, (IProgressMonitor)subMonitor.split(1));
                    jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)subMonitor.split(1));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!monitor.isCanceled()) {
                    try {
                        DebugUIPlugin.buildAndLaunch(configuration, mode, (IProgressMonitor)subMonitor.split(98));
                    }
                    catch (CoreException e2) {
                        throw new InvocationTargetException(e2);
                    }
                }
            };
            try {
                progressService.busyCursorWhile(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e2) {
                DebugUIPlugin.handleInvocationTargetException(e2, configuration, mode);
            }
        } else {
            IRunnableWithProgress runnable = monitor -> {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(DebugUIMessages.DebugUIPlugin_25, configuration.getName()), (int)1);
                try {
                    DebugUIPlugin.buildAndLaunch(configuration, mode, (IProgressMonitor)subMonitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                DebugUIPlugin.handleInvocationTargetException(e, configuration, mode);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void handleInvocationTargetException(InvocationTargetException e, ILaunchConfiguration configuration, String mode) {
        Throwable targetException = e.getTargetException();
        Throwable t = e;
        if (targetException instanceof CoreException) {
            t = targetException;
        }
        if (t instanceof CoreException) {
            ILaunchGroup group;
            CoreException ce = (CoreException)t;
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(ce.getStatus());
            if (handler != null && (group = DebugUITools.getLaunchGroup(configuration, mode)) != null) {
                DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)configuration), group.getIdentifier(), ce.getStatus());
                return;
            }
            if ((ce.getStatus().getSeverity() & 6) == 0) {
                return;
            }
        }
        DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.DebugUITools_Error_1, DebugUIMessages.DebugUITools_Exception_occurred_during_launch_2, t);
    }

    public static void launchInBackground(final ILaunchConfiguration configuration, final String mode) {
        final IJobManager jobManager = Job.getJobManager();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean wait = jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 && ResourcesPlugin.getWorkspace().isAutoBuilding() || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0;
        String waitPref = store.getString("org.eclipse.debug.ui.wait_for_build");
        if (wait) {
            if (waitPref.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)DebugUIPlugin.getShell(), (String)DebugUIMessages.DebugUIPlugin_23, (String)DebugUIMessages.DebugUIPlugin_24, null, (boolean)false, (IPreferenceStore)store, (String)"org.eclipse.debug.ui.wait_for_build");
                switch (dialog.getReturnCode()) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        wait = true;
                        break;
                    }
                    case 3: {
                        wait = false;
                        break;
                    }
                }
            } else {
                wait = waitPref.equals("always");
            }
        }
        final boolean waitInJob = wait;
        Job job = new Job(MessageFormat.format(DebugUIMessages.DebugUIPlugin_25, configuration.getName())){

            public IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)DebugUIMessages.DebugUITools_3, (int)100);
                try {
                    try {
                        if (waitInJob) {
                            StringBuilder buffer = new StringBuilder(configuration.getName());
                            buffer.append(DebugUIMessages.DebugUIPlugin_0);
                            ILaunchConfigurationWorkingCopy workingCopy = configuration.copy(buffer.toString());
                            workingCopy.setAttribute(ATTR_LAUNCHING_CONFIG_HANDLE, configuration.getMemento());
                            PendingLaunch pendingLaunch = new PendingLaunch((ILaunchConfiguration)workingCopy, mode, this);
                            DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)pendingLaunch);
                            IJobChangeListener listener = new IJobChangeListener((ILaunch)pendingLaunch){
                                private final /* synthetic */ ILaunch val$pendingLaunch;
                                {
                                    this.val$pendingLaunch = iLaunch;
                                }

                                public void sleeping(IJobChangeEvent event) {
                                }

                                public void scheduled(IJobChangeEvent event) {
                                }

                                public void running(IJobChangeEvent event) {
                                }

                                public void awake(IJobChangeEvent event) {
                                }

                                public void aboutToRun(IJobChangeEvent event) {
                                }

                                public void done(IJobChangeEvent event) {
                                    DebugPlugin dp = DebugPlugin.getDefault();
                                    if (dp != null) {
                                        dp.getLaunchManager().removeLaunch(this.val$pendingLaunch);
                                    }
                                    this.removeJobChangeListener(this);
                                }
                            };
                            this.addJobChangeListener(listener);
                            try {
                                jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, (IProgressMonitor)subMonitor.split(1));
                                jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)subMonitor.split(1));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            DebugPlugin.getDefault().getLaunchManager().removeLaunch((ILaunch)pendingLaunch);
                        }
                        subMonitor.setWorkRemaining(98);
                        if (!monitor.isCanceled()) {
                            DebugUIPlugin.buildAndLaunch(configuration, mode, (IProgressMonitor)subMonitor.split(98));
                        }
                    }
                    catch (CoreException e) {
                        ILaunchGroup group;
                        IStatus status;
                        block13: {
                            status = e.getStatus();
                            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
                            if (handler == null) {
                                IStatus iStatus = status;
                                monitor.done();
                                return iStatus;
                            }
                            group = DebugUITools.getLaunchGroup(configuration, mode);
                            if (group != null) break block13;
                            IStatus iStatus = status;
                            monitor.done();
                            return iStatus;
                        }
                        Runnable r = () -> {
                            int n = DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)configuration), group.getIdentifier(), status);
                        };
                        DebugUIPlugin.getStandardDisplay().asyncExec(r);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IProgressService progressService = workbench.getProgressService();
        job.setPriority(10);
        job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        job.setName(MessageFormat.format(DebugUIMessages.DebugUIPlugin_25, configuration.getName()));
        if (wait) {
            progressService.showInDialog(DebugUIPlugin.getShell(), job);
        }
        job.schedule();
    }

    public static String removeAccelerators(String label) {
        Object title = label;
        if (title != null) {
            int index = ((String)title).indexOf(38);
            if (index == 0) {
                title = ((String)title).substring(1);
            } else if (index > 0) {
                if (((String)title).charAt(index - 1) == '(' && ((String)title).length() >= index + 3 && ((String)title).charAt(index + 2) == ')') {
                    String first = ((String)title).substring(0, index - 1);
                    String last = ((String)title).substring(index + 3);
                    title = first + last;
                } else if (index < ((String)title).length() - 1) {
                    String first = ((String)title).substring(0, index);
                    String last = ((String)title).substring(index + 1);
                    title = first + last;
                }
            }
        }
        return title;
    }

    public static String adjustDBCSAccelerator(String label) {
        int index;
        Object title = label;
        if (title != null && (index = ((String)title).indexOf(38)) > 0 && ((String)title).charAt(index - 1) == '(' && ((String)title).length() >= index + 3 && ((String)title).charAt(index + 2) == ')') {
            String first = ((String)title).substring(0, index - 1);
            String accel = ((String)title).substring(index - 1, index + 3);
            String last = ((String)title).substring(index + 3);
            if (((String)(title = first + last)).endsWith("...")) {
                title = ((String)title).substring(0, ((String)title).length() - 3);
                title = (String)title + accel + "...";
            } else {
                title = (String)title + accel;
            }
        }
        return title;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (DebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            DebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return DebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static ImageDescriptor getImageDescriptor(IConfigurationElement element, String attr) {
        String iconPath = element.getAttribute(attr);
        if (iconPath != null) {
            Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            return ImageDescriptor.createFromURLSupplier((boolean)true, () -> {
                URL iconURL = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)iconPath), null);
                if (iconURL != null) {
                    return iconURL;
                }
                try {
                    return FileLocator.find((URL)new URL(iconPath));
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            });
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(String bundleName, String path) {
        if (path != null) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            return ImageDescriptor.createFromURLSupplier((boolean)true, () -> FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)path), null));
        }
        return null;
    }

    public static boolean doLaunchConfigurationFiltering(ILaunchConfiguration config) {
        boolean ret = true;
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_CLOSED")) {
            ret &= new ClosedProjectFilter().select(null, null, config);
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_DELETED")) {
            ret &= new DeletedProjectFilter().select(null, null, config);
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_TYPES")) {
            try {
                ret &= new LaunchConfigurationTypeFilter().select(null, null, config.getType());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return ret;
    }

    public static IEvaluationContext createEvaluationContext(Object defaultvar) {
        IEvaluationContext parent = null;
        IEvaluationService esrvc = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (esrvc != null) {
            parent = esrvc.getCurrentState();
        }
        return new EvaluationContext(parent, defaultvar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ISaveParticipant> getSaveParticipants() {
        LinkedHashSet<ISaveParticipant> copy = new LinkedHashSet<ISaveParticipant>();
        Set<ISaveParticipant> set = this.fSaveParticipants;
        synchronized (set) {
            copy.addAll(this.fSaveParticipants);
        }
        return copy;
    }

    public static class PendingLaunch
    extends Launch {
        private final Job fJob;

        public PendingLaunch(ILaunchConfiguration launchConfiguration, String mode, Job job) {
            super(launchConfiguration, mode, null);
            this.fJob = job;
        }

        public boolean canTerminate() {
            return true;
        }

        public void terminate() throws DebugException {
            this.fJob.cancel();
        }
    }
}

