/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.generator.PackageGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IPackage;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.internal.AbstractAnnotatableImplementor;
import org.eclipse.scout.sdk.core.java.model.api.query.AnnotationQuery;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;

public class PackageImplementor
extends AbstractAnnotatableImplementor<PackageSpi>
implements IPackage {
    public PackageImplementor(PackageSpi spi) {
        super(spi);
    }

    @Override
    public Path asPath() {
        String packageName = this.elementName();
        if (packageName == null) {
            return Paths.get("", new String[0]);
        }
        return Paths.get(packageName.replace('.', '/'), new String[0]);
    }

    @Override
    public Stream<? extends IJavaElement> children() {
        return this.annotations().stream();
    }

    @Override
    public Optional<IPackage> parent() {
        return Optional.ofNullable(((PackageSpi)this.m_spi).getParentPackage()).map(PackageSpi::wrap);
    }

    @Override
    public Optional<IType> packageInfo() {
        return Optional.ofNullable(((PackageSpi)this.m_spi).getPackageInfo()).map(TypeSpi::wrap);
    }

    @Override
    public AnnotationQuery<IAnnotation> annotations() {
        return this.packageInfo().map(pi -> new AnnotationQuery((IType)pi, this.m_spi)).orElseGet(() -> new EmptyAnnotationQuery(this.m_spi));
    }

    @Override
    public PackageGenerator toWorkingCopy() {
        return this.toWorkingCopy(null);
    }

    @Override
    public PackageGenerator toWorkingCopy(IWorkingCopyTransformer transformer) {
        return PackageGenerator.create(this, transformer);
    }

    private static class EmptyAnnotationQuery
    extends AnnotationQuery<IAnnotation> {
        public EmptyAnnotationQuery(JavaElementSpi owner) {
            super(null, owner);
        }

        @Override
        protected Stream<IAnnotation> createStream() {
            return Stream.empty();
        }
    }
}

