/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.internal;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.IFunction;
import org.eclipse.scout.sdk.core.typescript.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.DataTypeImplementor;
import org.eclipse.scout.sdk.core.typescript.model.api.query.FieldQuery;
import org.eclipse.scout.sdk.core.typescript.model.api.query.FunctionQuery;
import org.eclipse.scout.sdk.core.typescript.model.api.query.SupersQuery;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.TypeParameterSpi;

public class ES6ClassImplementor
extends DataTypeImplementor<ES6ClassSpi>
implements IES6Class {
    public ES6ClassImplementor(ES6ClassSpi spi) {
        super(spi);
    }

    @Override
    public FieldQuery fields() {
        return new FieldQuery((ES6ClassSpi)this.spi());
    }

    @Override
    public boolean isEnum() {
        return ((ES6ClassSpi)this.spi()).isEnum();
    }

    @Override
    public boolean isTypeAlias() {
        return ((ES6ClassSpi)this.spi()).isTypeAlias();
    }

    @Override
    public Optional<IDataType> aliasedDataType() {
        return ((ES6ClassSpi)this.spi()).aliasedDataType().map(DataTypeSpi::api);
    }

    @Override
    public boolean isInterface() {
        return ((ES6ClassSpi)this.spi()).isInterface();
    }

    @Override
    public boolean hasModifier(Modifier modifier) {
        return ((ES6ClassSpi)this.spi()).hasModifier(modifier);
    }

    @Override
    public IES6Class withoutTypeArguments() {
        return ((ES6ClassSpi)this.spi()).withoutTypeArguments().api();
    }

    @Override
    public boolean isInstanceOf(IES6Class es6Class) {
        if (es6Class == null) {
            return false;
        }
        IES6Class me = this.withoutTypeArguments();
        IES6Class raw = es6Class.withoutTypeArguments();
        if (raw == me) {
            return true;
        }
        return this.supers().stream().anyMatch(s -> s == raw);
    }

    @Override
    public FunctionQuery functions() {
        return new FunctionQuery((ES6ClassSpi)this.spi());
    }

    @Override
    public Optional<IFunction> function(String name) {
        return this.functions().withName(name).first();
    }

    @Override
    public Optional<IES6Class> superClass() {
        return ((ES6ClassSpi)this.spi()).superClass().map(ES6ClassSpi::api);
    }

    @Override
    public SupersQuery supers() {
        return new SupersQuery((ES6ClassSpi)this.spi());
    }

    @Override
    public Stream<IES6Class> superInterfaces() {
        return ((ES6ClassSpi)this.spi()).superInterfaces().map(ES6ClassSpi::api);
    }

    @Override
    public Optional<IField> field(String name) {
        return this.fields().withName(name).first();
    }

    @Override
    public boolean isPrimitive() {
        return ((ES6ClassSpi)this.spi()).isPrimitive();
    }

    @Override
    public Stream<IDataType> typeArguments() {
        return ((ES6ClassSpi)this.spi()).typeArguments().stream().map(DataTypeSpi::api);
    }

    @Override
    public Stream<ITypeParameter> typeParameters() {
        return ((ES6ClassSpi)this.spi()).typeParameters().stream().map(TypeParameterSpi::api);
    }
}

